/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Composite parent;
    boolean tracking;
    boolean stippled;
    Rectangle[] rectangles;
    Rectangle[] proportions;
    Rectangle bounds;
    int cursorOrientation = 0;
    int cursor;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite parent, int style) {
        super(parent, Tracker.checkStyle(style));
        this.parent = parent;
    }

    public Tracker(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(style);
        this.display = display;
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    Point adjustMoveCursor(int xDisplay, int xWindow) {
        int[] unused = new int[1];
        int[] actualX = new int[1];
        int[] actualY = new int[1];
        int newX = this.bounds.x + this.bounds.width / 2;
        int newY = this.bounds.y;
        OS.XWarpPointer(xDisplay, 0, xWindow, 0, 0, 0, 0, newX, newY);
        OS.XQueryPointer(xDisplay, xWindow, unused, unused, actualX, actualY, unused, unused, unused);
        return new Point(actualX[0], actualY[0]);
    }

    Point adjustResizeCursor(int xDisplay, int xWindow) {
        int newX = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int newY = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        int[] unused = new int[1];
        int[] actualX = new int[1];
        int[] actualY = new int[1];
        OS.XWarpPointer(xDisplay, 0, xWindow, 0, 0, 0, 0, newX, newY);
        OS.XQueryPointer(xDisplay, xWindow, unused, unused, actualX, actualY, unused, unused, unused);
        return new Point(actualX[0], actualY[0]);
    }

    static int checkStyle(int style) {
        if ((style & 0x24480) == 0) {
            style |= 0x24480;
        }
        return style;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        int xMin = this.rectangles[0].x;
        int yMin = this.rectangles[0].y;
        int xMax = this.rectangles[0].x + this.rectangles[0].width;
        int yMax = this.rectangles[0].y + this.rectangles[0].height;
        int i = 1;
        while (i < this.rectangles.length) {
            int rectBottom;
            int rectRight;
            if (this.rectangles[i].x < xMin) {
                xMin = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < yMin) {
                yMin = this.rectangles[i].y;
            }
            if ((rectRight = this.rectangles[i].x + this.rectangles[i].width) > xMax) {
                xMax = rectRight;
            }
            if ((rectBottom = this.rectangles[i].y + this.rectangles[i].height) > yMax) {
                yMax = rectBottom;
            }
            ++i;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    Rectangle[] computeProportions(Rectangle[] rects) {
        Rectangle[] result = new Rectangle[rects.length];
        this.bounds = this.computeBounds();
        int i = 0;
        while (i < rects.length) {
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            if (this.bounds.width != 0) {
                x = (rects[i].x - this.bounds.x) * 100 / this.bounds.width;
                width = rects[i].width * 100 / this.bounds.width;
            } else {
                width = 100;
            }
            if (this.bounds.height != 0) {
                y = (rects[i].y - this.bounds.y) * 100 / this.bounds.height;
                height = rects[i].height * 100 / this.bounds.height;
            } else {
                height = 100;
            }
            result[i] = new Rectangle(x, y, width, height);
            ++i;
        }
        return result;
    }

    void drawRectangles(Rectangle[] rects, boolean stippled) {
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            this.parent.getShell().update();
        } else {
            this.display.update();
        }
        int xDisplay = this.display.xDisplay;
        int color = OS.XWhitePixel(xDisplay, 0);
        int xWindow = OS.XDefaultRootWindow(xDisplay);
        if (this.parent != null) {
            xWindow = OS.XtWindow(this.parent.handle);
            if (xWindow == 0) {
                return;
            }
            int[] nArray = new int[4];
            nArray[0] = OS.XmNforeground;
            nArray[2] = OS.XmNbackground;
            int[] argList = nArray;
            OS.XtGetValues(this.parent.handle, argList, argList.length / 2);
            color = argList[1] ^ argList[3];
        }
        int gc = OS.XCreateGC(xDisplay, xWindow, 0, null);
        OS.XSetForeground(xDisplay, gc, color);
        OS.XSetSubwindowMode(xDisplay, gc, 1);
        OS.XSetFunction(xDisplay, gc, 6);
        int stipplePixmap = 0;
        if (stippled) {
            byte[] byArray = new byte[16];
            byArray[0] = -86;
            byArray[2] = 85;
            byArray[4] = -86;
            byArray[6] = 85;
            byArray[8] = -86;
            byArray[10] = 85;
            byArray[12] = -86;
            byArray[14] = 85;
            byte[] bits = byArray;
            stipplePixmap = OS.XCreateBitmapFromData(xDisplay, xWindow, bits, 8, 8);
            OS.XSetStipple(xDisplay, gc, stipplePixmap);
            OS.XSetFillStyle(xDisplay, gc, 2);
            OS.XSetLineAttributes(xDisplay, gc, 3, 0, 1, 0);
        }
        int i = 0;
        while (i < rects.length) {
            Rectangle rect = rects[i];
            OS.XDrawRectangle(xDisplay, xWindow, gc, rect.x, rect.y, rect.width, rect.height);
            ++i;
        }
        if (stippled) {
            OS.XFreePixmap(xDisplay, stipplePixmap);
        }
        OS.XFreeGC(xDisplay, gc);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        int length = 0;
        if (this.rectangles != null) {
            length = this.rectangles.length;
        }
        Rectangle[] result = new Rectangle[length];
        int i = 0;
        while (i < length) {
            Rectangle current = this.rectangles[i];
            result[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        return result;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void moveRectangles(int xChange, int yChange) {
        if (xChange < 0 && (this.style & 0x4000) == 0) {
            xChange = 0;
        }
        if (xChange > 0 && (this.style & 0x20000) == 0) {
            xChange = 0;
        }
        if (yChange < 0 && (this.style & 0x80) == 0) {
            yChange = 0;
        }
        if (yChange > 0 && (this.style & 0x400) == 0) {
            yChange = 0;
        }
        if (xChange == 0 && yChange == 0) {
            return;
        }
        this.bounds.x += xChange;
        this.bounds.y += yChange;
        int i = 0;
        while (i < this.rectangles.length) {
            this.rectangles[i].x += xChange;
            this.rectangles[i].y += yChange;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean open() {
        this.checkWidget();
        if (this.rectangles == null) {
            return false;
        }
        xDisplay = this.display.xDisplay;
        xWindow = OS.XDefaultRootWindow(xDisplay);
        if (this.parent != null && (xWindow = OS.XtWindow(this.parent.handle)) == 0) {
            return false;
        }
        cancelled = false;
        this.tracking = true;
        this.drawRectangles(this.rectangles, this.stippled);
        oldX = new int[1];
        oldY = new int[1];
        unused = new int[1];
        mask = new int[1];
        OS.XQueryPointer(xDisplay, xWindow, unused, unused, oldX, oldY, unused, unused, mask);
        vStyle = this.style & 1152;
        if (vStyle == 128 || vStyle == 1024) {
            this.cursorOrientation |= vStyle;
        }
        if ((hStyle = this.style & 147456) == 16384 || hStyle == 131072) {
            this.cursorOrientation |= hStyle;
        }
        v0 = mouseDown = (mask[0] & (mouseMasks = 1792)) != 0;
        if (!mouseDown) {
            cursorPos = (this.style & 16) != 0 ? this.adjustResizeCursor(xDisplay, xWindow) : this.adjustMoveCursor(xDisplay, xWindow);
            oldX[0] = cursorPos.x;
            oldY[0] = cursorPos.y;
        }
        xEvent = OS.XtMalloc(96);
        anyEvent = new XEvent();
        newX = new int[1];
        newY = new int[1];
        xtContext = OS.XtDisplayToApplicationContext(xDisplay);
        ptrGrabResult = OS.XGrabPointer(xDisplay, xWindow, 0, 76, 1, 1, 0, 0, 0);
        kbdGrabResult = OS.XGrabKeyboard(xDisplay, xWindow, 0, 1, 1, 0);
        block14: while (this.tracking) {
            if (this.parent != null && this.parent.isDisposed()) break;
            OS.XtAppNextEvent(xtContext, xEvent);
            OS.memmove(anyEvent, xEvent, 96);
            switch (anyEvent.type) {
                case 6: {
                    if (this.cursor != 0) {
                        OS.XChangeActivePointerGrab(xDisplay, 76, this.cursor, 0);
                    }
                }
                case 5: {
                    OS.XQueryPointer(xDisplay, xWindow, unused, unused, newX, newY, unused, unused, unused);
                    if (oldX[0] == newX[0] && oldY[0] == newY[0]) ** GOTO lbl112
                    oldRectangles = this.rectangles;
                    oldStippled = this.stippled;
                    rectsToErase = new Rectangle[this.rectangles.length];
                    i = 0;
                    while (i < this.rectangles.length) {
                        current = this.rectangles[i];
                        rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                        ++i;
                    }
                    event = new Event();
                    event.x = newX[0];
                    event.y = newY[0];
                    if ((this.style & 16) == 0) ** GOTO lbl87
                    this.resizeRectangles(newX[0] - oldX[0], newY[0] - oldY[0]);
                    this.sendEvent(11, event);
                    if (this.isDisposed()) {
                        cancelled = true;
                        break;
                    }
                    draw = false;
                    if (this.rectangles == oldRectangles) ** GOTO lbl79
                    length = this.rectangles.length;
                    if (length == rectsToErase.length) ** GOTO lbl71
                    draw = true;
                    ** GOTO lbl80
lbl71:
                    // 1 sources

                    i = 0;
                    while (i < length) {
                        if (this.rectangles[i].equals(rectsToErase[i])) ** GOTO lbl76
                        draw = true;
                        ** GOTO lbl80
lbl76:
                        // 1 sources

                        ++i;
                    }
                    ** GOTO lbl80
lbl79:
                    // 1 sources

                    draw = true;
lbl80:
                    // 4 sources

                    if (draw) {
                        this.drawRectangles(rectsToErase, oldStippled);
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    cursorPos = this.adjustResizeCursor(xDisplay, xWindow);
                    newX[0] = cursorPos.x;
                    newY[0] = cursorPos.y;
                    ** GOTO lbl110
lbl87:
                    // 1 sources

                    this.moveRectangles(newX[0] - oldX[0], newY[0] - oldY[0]);
                    this.sendEvent(10, event);
                    if (this.isDisposed()) {
                        cancelled = true;
                        break;
                    }
                    draw = false;
                    if (this.rectangles == oldRectangles) ** GOTO lbl106
                    length = this.rectangles.length;
                    if (length == rectsToErase.length) ** GOTO lbl98
                    draw = true;
                    ** GOTO lbl107
lbl98:
                    // 1 sources

                    i = 0;
                    while (i < length) {
                        if (this.rectangles[i].equals(rectsToErase[i])) ** GOTO lbl103
                        draw = true;
                        ** GOTO lbl107
lbl103:
                        // 1 sources

                        ++i;
                    }
                    ** GOTO lbl107
lbl106:
                    // 1 sources

                    draw = true;
lbl107:
                    // 4 sources

                    if (draw) {
                        this.drawRectangles(rectsToErase, oldStippled);
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
lbl110:
                    // 4 sources

                    oldX[0] = newX[0];
                    oldY[0] = newY[0];
lbl112:
                    // 2 sources

                    this.tracking = anyEvent.type != 5;
                    break;
                }
                case 2: {
                    keyEvent = new XKeyEvent();
                    OS.memmove(keyEvent, xEvent, 60);
                    if (keyEvent.keycode == 0) continue block14;
                    keysym = new int[1];
                    OS.XLookupString(keyEvent, null, 0, keysym, null);
                    keysym[0] = keysym[0] & 65535;
                    xChange = 0;
                    yChange = 0;
                    stepSize = (keyEvent.state & 4) != 0 ? 1 : 9;
                    switch (keysym[0]) {
                        case 65293: 
                        case 65421: {
                            this.tracking = false;
                            OS.XtAppNextEvent(xtContext, xEvent);
                            break;
                        }
                        case 65307: {
                            this.tracking = false;
                            cancelled = true;
                            OS.XtAppNextEvent(xtContext, xEvent);
                            break;
                        }
                        case 65361: {
                            xChange = -stepSize;
                            break;
                        }
                        case 65363: {
                            xChange = stepSize;
                            break;
                        }
                        case 65362: {
                            yChange = -stepSize;
                            break;
                        }
                        case 65364: {
                            yChange = stepSize;
                        }
                    }
                    if (xChange == 0 && yChange == 0) continue block14;
                    oldRectangles = this.rectangles;
                    oldStippled = this.stippled;
                    rectsToErase = new Rectangle[this.rectangles.length];
                    i = 0;
                    while (i < this.rectangles.length) {
                        current = this.rectangles[i];
                        rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                        ++i;
                    }
                    event = new Event();
                    event.x = oldX[0] + xChange;
                    event.y = oldY[0] + yChange;
                    if ((this.style & 16) == 0) ** GOTO lbl185
                    this.resizeRectangles(xChange, yChange);
                    this.sendEvent(11, event);
                    if (this.isDisposed()) {
                        cancelled = true;
                        break;
                    }
                    draw = false;
                    if (this.rectangles == oldRectangles) ** GOTO lbl179
                    length = this.rectangles.length;
                    if (length == rectsToErase.length) ** GOTO lbl171
                    draw = true;
                    ** GOTO lbl180
lbl171:
                    // 1 sources

                    i = 0;
                    while (i < length) {
                        if (this.rectangles[i].equals(rectsToErase[i])) ** GOTO lbl176
                        draw = true;
                        ** GOTO lbl180
lbl176:
                        // 1 sources

                        ++i;
                    }
                    ** GOTO lbl180
lbl179:
                    // 1 sources

                    draw = true;
lbl180:
                    // 4 sources

                    if (draw) {
                        this.drawRectangles(rectsToErase, oldStippled);
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    cursorPos = this.adjustResizeCursor(xDisplay, xWindow);
                    ** GOTO lbl209
lbl185:
                    // 1 sources

                    this.moveRectangles(xChange, yChange);
                    this.sendEvent(10, event);
                    if (this.isDisposed()) {
                        cancelled = true;
                        break;
                    }
                    draw = false;
                    if (this.rectangles == oldRectangles) ** GOTO lbl204
                    length = this.rectangles.length;
                    if (length == rectsToErase.length) ** GOTO lbl196
                    draw = true;
                    ** GOTO lbl205
lbl196:
                    // 1 sources

                    i = 0;
                    while (i < length) {
                        if (this.rectangles[i].equals(rectsToErase[i])) ** GOTO lbl201
                        draw = true;
                        ** GOTO lbl205
lbl201:
                        // 1 sources

                        ++i;
                    }
                    ** GOTO lbl205
lbl204:
                    // 1 sources

                    draw = true;
lbl205:
                    // 4 sources

                    if (draw) {
                        this.drawRectangles(rectsToErase, oldStippled);
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    cursorPos = this.adjustMoveCursor(xDisplay, xWindow);
lbl209:
                    // 2 sources

                    oldX[0] = cursorPos.x;
                    oldY[0] = cursorPos.y;
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    OS.XtDispatchEvent(xEvent);
                }
            }
        }
        OS.XtFree(xEvent);
        if (!this.isDisposed()) {
            this.drawRectangles(this.rectangles, this.stippled);
        }
        if (ptrGrabResult == 0) {
            OS.XUngrabPointer(xDisplay, 0);
        }
        if (kbdGrabResult == 0) {
            OS.XUngrabKeyboard(xDisplay, 0);
        }
        return cancelled == false;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, listener);
        this.eventTable.unhook(10, listener);
    }

    void resizeRectangles(int xChange, int yChange) {
        Rectangle proportion;
        int i;
        if (xChange < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        } else if (xChange > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        } else if (yChange < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        } else if (yChange > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (xChange > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                xChange -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.x = 100 - proportion.x - proportion.width;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -xChange) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            xChange += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.x = 100 - proportion.x - proportion.width;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (yChange > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                yChange -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.y = 100 - proportion.y - proportion.height;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -yChange) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            yChange += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.y = 100 - proportion.y - proportion.height;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += xChange;
            this.bounds.width -= xChange;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += xChange;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += yChange;
            this.bounds.height -= yChange;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += yChange;
        }
        Rectangle[] newRects = new Rectangle[this.rectangles.length];
        int i2 = 0;
        while (i2 < this.rectangles.length) {
            Rectangle proportion2 = this.proportions[i2];
            newRects[i2] = new Rectangle(proportion2.x * this.bounds.width / 100 + this.bounds.x, proportion2.y * this.bounds.height / 100 + this.bounds.y, proportion2.width * this.bounds.width / 100, proportion2.height * this.bounds.height / 100);
            ++i2;
        }
        this.rectangles = newRects;
    }

    public void setCursor(Cursor value) {
        this.checkWidget();
        this.cursor = 0;
        if (value != null) {
            this.cursor = value.handle;
        }
    }

    public void setRectangles(Rectangle[] rectangles) {
        this.checkWidget();
        if (rectangles == null) {
            this.error(4);
        }
        int length = rectangles.length;
        this.rectangles = new Rectangle[length];
        int i = 0;
        while (i < length) {
            Rectangle current = rectangles[i];
            if (current == null) {
                this.error(4);
            }
            this.rectangles[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        this.proportions = this.computeProportions(rectangles);
    }

    public void setStippled(boolean stippled) {
        this.checkWidget();
        this.stippled = stippled;
    }
}

