/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XtWidgetGeometry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Button
extends Control {
    String text = "";
    Image image;
    Image bitmap;
    Image disabled;
    static final byte[] ARM_AND_ACTIVATE;

    static {
        String name = "ArmAndActivate";
        int length = name.length();
        char[] unicode = new char[length];
        name.getChars(0, length, unicode, 0);
        byte[] buffer = new byte[length + 1];
        int i = 0;
        while (i < length) {
            buffer[i] = (byte)unicode[i];
            ++i;
        }
        ARM_AND_ACTIVATE = buffer;
    }

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        if (((style = Widget.checkBits(style, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Widget.checkBits(style, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((style & 0x30) != 0) {
            return Widget.checkBits(style, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((style & 4) != 0) {
            return Widget.checkBits(style |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return style;
    }

    void click() {
        int event = OS.XtMalloc(96);
        OS.XtCallActionProc(this.handle, ARM_AND_ACTIVATE, event, null, 0);
        OS.XtFree(event);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 4) != 0) {
            width += this.display.scrolledMarginX;
            height += this.display.scrolledMarginY;
            if (wHint != -1) {
                width = wHint + border * 2;
            }
            if (hHint != -1) {
                height = hHint + border * 2;
            }
            return new Point(width, height);
        }
        XtWidgetGeometry result = new XtWidgetGeometry();
        result.request_mode = 12;
        int[] argList2 = new int[]{OS.XmNrecomputeSize, 1};
        OS.XtSetValues(this.handle, argList2, argList2.length / 2);
        OS.XtQueryGeometry(this.handle, null, result);
        int[] nArray = new int[2];
        nArray[0] = OS.XmNrecomputeSize;
        int[] argList3 = nArray;
        OS.XtSetValues(this.handle, argList3, argList3.length / 2);
        width += result.width;
        height += result.height;
        int[] nArray2 = new int[2];
        nArray2[0] = OS.XmNlabelType;
        int[] argList = nArray2;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (argList[1] == 2) {
            int[] nArray3 = new int[2];
            nArray3[0] = OS.XmNlabelString;
            int[] argList1 = nArray3;
            OS.XtGetValues(this.handle, argList1, argList1.length / 2);
            int xmString = argList1[1];
            if (OS.XmStringEmpty(xmString)) {
                height += this.getFontHeight(this.font.handle);
            }
            if (xmString != 0) {
                OS.XmStringFree(xmString);
            }
        }
        if (wHint != -1 || hHint != -1) {
            int[] nArray4 = new int[8];
            nArray4[0] = OS.XmNmarginLeft;
            nArray4[2] = OS.XmNmarginRight;
            nArray4[4] = OS.XmNmarginTop;
            nArray4[6] = OS.XmNmarginBottom;
            int[] argList4 = nArray4;
            OS.XtGetValues(this.handle, argList4, argList4.length / 2);
            if (wHint != -1) {
                width = wHint + argList4[1] + argList4[3] + border * 2;
            }
            if (hHint != -1) {
                height = hHint + argList4[5] + argList4[7] + border * 2;
            }
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 8;
        int borderWidth = (this.style & 0x800) != 0 ? 1 : 0;
        int parentHandle = this.parent.handle;
        if ((this.style & 4) != 0) {
            int alignment = 0;
            if ((this.style & 0x80) != 0) {
                alignment = 0;
            }
            if ((this.style & 0x400) != 0) {
                alignment = 1;
            }
            if ((this.style & 0x4000) != 0) {
                alignment = 2;
            }
            if ((this.style & 0x20000) != 0) {
                alignment = 3;
            }
            int[] nArray = new int[8];
            nArray[0] = OS.XmNtraversalOn;
            nArray[2] = OS.XmNarrowDirection;
            nArray[3] = alignment;
            nArray[4] = OS.XmNborderWidth;
            nArray[5] = borderWidth;
            nArray[6] = OS.XmNancestorSensitive;
            nArray[7] = 1;
            int[] argList = nArray;
            this.handle = OS.XmCreateArrowButton(parentHandle, null, argList, argList.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            if ((this.style & 0x800000) != 0) {
                int[] nArray2 = new int[2];
                nArray2[0] = OS.XmNbottomShadowColor;
                int[] argList1 = nArray2;
                OS.XtGetValues(this.handle, argList1, argList1.length / 2);
                int[] argList2 = new int[]{OS.XmNshadowThickness, 1, OS.XmNtopShadowColor, argList1[1]};
                OS.XtSetValues(this.handle, argList2, argList2.length / 2);
            }
            return;
        }
        int alignment = 0;
        if ((this.style & 0x1000000) != 0) {
            alignment = 1;
        }
        if ((this.style & 0x20000) != 0) {
            alignment = 2;
        }
        if ((this.style & 2) != 0) {
            int thickness = this.display.buttonShadowThickness;
            int[] nArray = new int[12];
            nArray[0] = OS.XmNancestorSensitive;
            nArray[1] = 1;
            nArray[2] = OS.XmNrecomputeSize;
            nArray[4] = OS.XmNindicatorOn;
            nArray[6] = OS.XmNshadowThickness;
            nArray[7] = (this.style & 0x800000) != 0 ? 1 : thickness;
            nArray[8] = OS.XmNalignment;
            nArray[9] = alignment;
            nArray[10] = OS.XmNborderWidth;
            nArray[11] = borderWidth;
            int[] argList = nArray;
            this.handle = OS.XmCreateToggleButton(parentHandle, null, argList, argList.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            if ((this.style & 0x800000) != 0) {
                int[] nArray3 = new int[2];
                nArray3[0] = OS.XmNbottomShadowColor;
                int[] argList1 = nArray3;
                OS.XtGetValues(this.handle, argList1, argList1.length / 2);
                int[] argList2 = new int[]{OS.XmNtopShadowColor, argList1[1]};
                OS.XtSetValues(this.handle, argList2, argList2.length / 2);
            }
            return;
        }
        if ((this.style & 0x30) != 0) {
            int indicatorType = 2;
            if ((this.style & 0x20) != 0) {
                indicatorType = 1;
            }
            int[] nArray = new int[10];
            nArray[0] = OS.XmNancestorSensitive;
            nArray[1] = 1;
            nArray[2] = OS.XmNrecomputeSize;
            nArray[4] = OS.XmNindicatorType;
            nArray[5] = indicatorType;
            nArray[6] = OS.XmNalignment;
            nArray[7] = alignment;
            nArray[8] = OS.XmNborderWidth;
            nArray[9] = borderWidth;
            int[] argList = nArray;
            this.handle = OS.XmCreateToggleButton(parentHandle, null, argList, argList.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            return;
        }
        int[] nArray = new int[8];
        nArray[0] = OS.XmNancestorSensitive;
        nArray[1] = 1;
        nArray[2] = OS.XmNrecomputeSize;
        nArray[4] = OS.XmNalignment;
        nArray[5] = alignment;
        nArray[6] = OS.XmNborderWidth;
        nArray[7] = borderWidth;
        int[] argList = nArray;
        this.handle = OS.XmCreatePushButton(parentHandle, null, argList, argList.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x800000) != 0) {
            int[] nArray4 = new int[2];
            nArray4[0] = OS.XmNbottomShadowColor;
            int[] argList1 = nArray4;
            OS.XtGetValues(this.handle, argList1, argList1.length / 2);
            int[] argList2 = new int[]{OS.XmNshadowThickness, 1, OS.XmNtopShadowColor, argList1[1]};
            OS.XtSetValues(this.handle, argList2, argList2.length / 2);
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        if ((this.style & 8) == 0) {
            return;
        }
        if (this.getShell().parent == null) {
            return;
        }
        int[] argList = new int[]{OS.XmNdefaultButtonShadowThickness, 1};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    int defaultBackground() {
        return this.display.buttonBackground;
    }

    Font defaultFont() {
        return this.display.buttonFont;
    }

    int defaultForeground() {
        return this.display.buttonForeground;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNarrowDirection;
            int[] argList = nArray;
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            int direction = argList[1];
            if (direction == 0) {
                return 128;
            }
            if (direction == 1) {
                return 1024;
            }
            if (direction == 2) {
                return 16384;
            }
            if (direction == 3) {
                return 131072;
            }
            return 128;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNalignment;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int alignment = argList[1];
        if (alignment == 0) {
            return 16384;
        }
        if (alignment == 1) {
            return 0x1000000;
        }
        if (alignment == 2) {
            return 131072;
        }
        return 0x1000000;
    }

    boolean getDefault() {
        if ((this.style & 8) == 0) {
            return false;
        }
        return this == this.menuShell().defaultButton;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNset;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1] != 0;
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        return this.text;
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        if ((this.style & 0x32) != 0) {
            OS.XtAddCallback(this.handle, OS.XmNvalueChangedCallback, windowProc, 25);
        } else {
            OS.XtAddCallback(this.handle, OS.XmNactivateCallback, windowProc, 9);
        }
    }

    boolean mnemonicHit(char key) {
        if (!this.setFocus()) {
            return false;
        }
        this.click();
        return true;
    }

    boolean mnemonicMatch(char key) {
        char mnemonic = this.findMnemonic(this.getText());
        if (mnemonic == '\u0000') {
            return false;
        }
        return Character.toUpperCase(key) == Character.toUpperCase(mnemonic);
    }

    void releaseWidget() {
        super.releaseWidget();
        int[] argList = new int[]{OS.XmNlabelPixmap, 2, OS.XmNlabelInsensitivePixmap, 2};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        if (this.bitmap != null) {
            this.bitmap.dispose();
        }
        if (this.disabled != null) {
            this.disabled.dispose();
        }
        this.disabled = null;
        this.bitmap = null;
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectRadio() {
        Control[] children = this.parent._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (this != child) {
                child.setRadioSelection(false);
            }
            ++i;
        }
        this.setSelection(true);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNarrowDirection;
            int[] argList = nArray;
            if ((alignment & 0x80) != 0) {
                argList[1] = 0;
            }
            if ((alignment & 0x400) != 0) {
                argList[1] = 1;
            }
            if ((alignment & 0x4000) != 0) {
                argList[1] = 2;
            }
            if ((alignment & 0x20000) != 0) {
                argList[1] = 3;
            }
            OS.XtSetValues(this.handle, argList, argList.length / 2);
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNalignment;
        int[] argList = nArray;
        if ((alignment & 0x1000000) != 0) {
            argList[1] = 1;
        }
        if ((alignment & 0x20000) != 0) {
            argList[1] = 2;
        }
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        if ((this.style & 0x800000) != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNbottomShadowColor;
            int[] argList1 = nArray;
            OS.XtGetValues(this.handle, argList1, argList1.length / 2);
            int[] argList2 = new int[]{OS.XmNtopShadowColor, argList1[1]};
            OS.XtSetValues(this.handle, argList2, argList2.length / 2);
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNlabelType;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (argList[1] == 1) {
            this.setBitmap(this.image);
        }
    }

    void setBitmap(Image image) {
        int labelPixmap = 2;
        int labelInsensitivePixmap = 2;
        if (this.bitmap != null) {
            this.bitmap.dispose();
        }
        if (this.disabled != null) {
            this.disabled.dispose();
        }
        this.disabled = null;
        this.bitmap = null;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            switch (image.type) {
                case 0: {
                    labelPixmap = image.pixmap;
                    this.disabled = new Image((Device)this.display, image, 1);
                    labelInsensitivePixmap = this.disabled.pixmap;
                    break;
                }
                case 1: {
                    Rectangle rect = image.getBounds();
                    this.bitmap = new Image((Device)this.display, rect.width, rect.height);
                    GC gc = new GC(this.bitmap);
                    gc.setBackground(this.getBackground());
                    gc.fillRectangle(rect);
                    gc.drawImage(image, 0, 0);
                    gc.dispose();
                    labelPixmap = this.bitmap.pixmap;
                    this.disabled = new Image((Device)this.display, this.bitmap, 1);
                    labelInsensitivePixmap = this.disabled.pixmap;
                    break;
                }
                default: {
                    this.error(20);
                }
            }
        }
        int[] argList = new int[]{OS.XmNlabelType, 1, OS.XmNlabelPixmap, labelPixmap, OS.XmNlabelInsensitivePixmap, labelInsensitivePixmap};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    void setDefault(boolean value) {
        if ((this.style & 8) == 0) {
            return;
        }
        if (this.getShell().parent == null) {
            return;
        }
        int[] argList = new int[]{OS.XmNshowAsDefault, value ? 1 : 0};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    public void setFont(Font font) {
        boolean fixString;
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNlabelString;
        nArray[2] = OS.XmNlabelType;
        int[] argList1 = nArray;
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        boolean bl = fixString = OS.IsDBLocale && OS.XmStringEmpty(argList1[1]);
        if (fixString) {
            byte[] buffer = Converter.wcsToMbcs(this.getCodePage(), "string", true);
            int xmString = OS.XmStringCreateLocalized(buffer);
            int[] argList2 = new int[]{OS.XmNlabelType, 2, OS.XmNlabelString, xmString};
            OS.XtSetValues(this.handle, argList2, argList2.length / 2);
            OS.XmStringFree(xmString);
        }
        super.setFont(font);
        if (fixString) {
            OS.XtSetValues(this.handle, argList1, argList1.length / 2);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.image = image;
        this.setBitmap(this.image);
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNset, selected ? 1 : 0};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        this.updateShadows();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        char[] text = new char[string.length()];
        string.getChars(0, text.length, text, 0);
        int mnemonic = this.fixMnemonic(text);
        byte[] buffer = Converter.wcsToMbcs(this.getCodePage(), text, true);
        int xmString = OS.XmStringParseText(buffer, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        if (xmString == 0) {
            this.error(13);
        }
        if (mnemonic == 0) {
            mnemonic = 0xFFFFFF;
        }
        int[] argList = new int[]{OS.XmNlabelType, 2, OS.XmNlabelString, xmString, OS.XmNmnemonic, mnemonic};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        if (xmString != 0) {
            OS.XmStringFree(xmString);
        }
    }

    int traversalCode(int key, XKeyEvent xEvent) {
        return super.traversalCode(key, xEvent) | 0x80;
    }

    void updateShadows() {
        if ((this.style & 0x800000) != 0 && (this.style & 2) != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNset;
            int[] argList1 = nArray;
            OS.XtGetValues(this.handle, argList1, argList1.length / 2);
            int pixel = argList1[1] == 0 ? this.display.compositeBottomShadow : this.display.compositeTopShadow;
            int[] argList2 = new int[]{OS.XmNtopShadowColor, pixel};
            OS.XtSetValues(this.handle, argList2, argList2.length / 2);
        }
    }

    int xFocusIn(XFocusChangeEvent xEvent) {
        super.xFocusIn(xEvent);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 8) != 0) {
            this.menuShell().setDefaultButton(this, false);
        }
        return 0;
    }

    int xFocusOut(XFocusChangeEvent xEvent) {
        super.xFocusOut(xEvent);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 8) != 0 && this.getDefault()) {
            this.menuShell().setDefaultButton(null, false);
        }
        return 0;
    }

    int XmNactivateCallback(int w, int client_data, int call_data) {
        this.postEvent(13);
        return 0;
    }

    int XmNvalueChangedCallback(int w, int client_data, int call_data) {
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.updateShadows();
        this.postEvent(13);
        return 0;
    }
}

