/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBField;
import org.firebirdsql.jdbc.FBResultSet;

class FBTimeField
extends FBField {
    FBTimeField(XSQLVAR field, FBResultSet rs, int numCol) throws SQLException {
        super(field, rs, numCol);
    }

    Object getObject() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return XSQLVAR.decodeTime(this.rs.row[this.numCol]);
    }

    String getString() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return String.valueOf(XSQLVAR.decodeTime(this.rs.row[this.numCol]));
    }

    Time getTime() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return XSQLVAR.decodeTime(this.rs.row[this.numCol]);
    }

    Time getTime(Calendar cal) throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return XSQLVAR.decodeTime(this.getTime(), cal);
    }

    Timestamp getTimestamp() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return new Timestamp(this.getTime().getTime());
    }

    Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return XSQLVAR.decodeTimestamp(this.getTimestamp(), cal);
    }

    void setString(String value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setTime(Time.valueOf(value));
    }

    void setTime(Time value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.field.sqldata = XSQLVAR.encodeTime(value);
    }

    void setTime(Time value, Calendar cal) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setTime(XSQLVAR.encodeTime(value, cal));
    }

    void setTimestamp(Timestamp value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setTime(new Time(((Date)value).getTime()));
    }

    void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setTimestamp(XSQLVAR.encodeTimestamp(value, cal));
    }
}

