/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBField;
import org.firebirdsql.jdbc.FBResultSet;

class FBShortField
extends FBField {
    FBShortField(XSQLVAR field, FBResultSet rs, int numCol) throws SQLException {
        super(field, rs, numCol);
    }

    BigDecimal getBigDecimal() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return BigDecimal.valueOf(XSQLVAR.decodeShort(this.rs.row[this.numCol]));
    }

    boolean getBoolean() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return false;
        }
        return XSQLVAR.decodeShort(this.rs.row[this.numCol]) == 1;
    }

    byte getByte() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Short value = new Short(XSQLVAR.decodeShort(this.rs.row[this.numCol]));
        if (value > 127 || value < -128) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.BYTE_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        return value.byteValue();
    }

    double getDouble() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0;
        }
        return XSQLVAR.decodeShort(this.rs.row[this.numCol]);
    }

    float getFloat() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0f;
        }
        return XSQLVAR.decodeShort(this.rs.row[this.numCol]);
    }

    int getInt() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        return XSQLVAR.decodeShort(this.rs.row[this.numCol]);
    }

    long getLong() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0L;
        }
        return XSQLVAR.decodeShort(this.rs.row[this.numCol]);
    }

    Object getObject() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return new Short(XSQLVAR.decodeShort(this.rs.row[this.numCol]));
    }

    short getShort() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        return XSQLVAR.decodeShort(this.rs.row[this.numCol]);
    }

    String getString() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return String.valueOf(XSQLVAR.decodeShort(this.rs.row[this.numCol]));
    }

    void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        if (value.compareTo(BigDecimal.valueOf(32767L)) > 0 || value.compareTo(BigDecimal.valueOf(-32768L)) < 0) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.BIGDECIMAL_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        this.setShort(value.shortValue());
    }

    void setBoolean(boolean value) throws SQLException {
        this.setShort((short)(value ? 1 : 0));
    }

    void setByte(byte value) throws SQLException {
        this.setShort(value);
    }

    void setDouble(double value) throws SQLException {
        if (value > 32767.0 || value < -32768.0) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.DOUBLE_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        this.setShort((short)value);
    }

    void setFloat(float value) throws SQLException {
        if (value > 32767.0f || value < -32768.0f) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.LONG_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        this.setShort((short)value);
    }

    void setInteger(int value) throws SQLException {
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.LONG_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        this.setShort((short)value);
    }

    void setLong(long value) throws SQLException {
        if (value > 32767L || value < -32768L) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.LONG_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        this.setShort((short)value);
    }

    void setShort(short value) throws SQLException {
        this.field.sqldata = XSQLVAR.encodeShort(value);
    }

    void setString(String value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        try {
            this.setShort(Short.parseShort(value));
        }
        catch (NumberFormatException numberFormatException) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.SHORT_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
    }
}

