/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.XSQLDA;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBBlobField;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBField;
import org.firebirdsql.jdbc.FBFlushableField;
import org.firebirdsql.jdbc.FBResultSetMetaData;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.jdbc.FBStringField;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class FBPreparedStatement
extends FBStatement
implements PreparedStatement {
    private boolean[] isParamSet;
    private FBField[] fields = null;
    private boolean[] isBlob = null;
    private boolean hasBlobs = false;
    private boolean isExecuteProcedureStatement;
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$jdbc$FBStatement != null ? class$org$firebirdsql$jdbc$FBStatement : (class$org$firebirdsql$jdbc$FBStatement = FBPreparedStatement.class$("org.firebirdsql.jdbc.FBStatement")), false);
    static /* synthetic */ Class class$org$firebirdsql$jdbc$FBStatement;

    FBPreparedStatement(FBConnection c, String sql) throws SQLException {
        super(c, 1007);
        try {
            try {
                c.ensureInTransaction();
                this.prepareFixedStatement(sql, true);
            }
            catch (GDSException ge) {
                if (log != null) {
                    log.info("GDSException in PreparedStatement constructor", ge);
                }
                throw new FBSQLException(ge);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            c.checkEndTransaction();
            throw throwable;
        }
        c.checkEndTransaction();
    }

    public void addBatch() throws SQLException {
        throw new SQLException("not yet implemented");
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void clearParameters() throws SQLException {
        int i = 0;
        while (i < this.isParamSet.length) {
            this.isParamSet[i] = false;
            ++i;
        }
    }

    public boolean execute() throws SQLException {
        boolean bl;
        try {
            this.c.ensureInTransaction();
            boolean hasResultSet = this.internalExecute(this.isExecuteProcedureStatement);
            if (hasResultSet && this.c.willEndTransaction()) {
                this.getCachedResultSet(false);
            }
            bl = hasResultSet;
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.c.checkEndTransaction();
            throw throwable;
        }
        this.c.checkEndTransaction();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet executeQuery() throws SQLException {
        ResultSet resultSet;
        block5: {
            ResultSet resultSet2;
            block4: {
                try {
                    this.c.ensureInTransaction();
                    if (!this.internalExecute(this.isExecuteProcedureStatement)) {
                        throw new SQLException("No resultset for sql");
                    }
                    if (this.c.willEndTransaction()) {
                        resultSet2 = this.getCachedResultSet(false);
                        Object var3_3 = null;
                        break block4;
                    }
                    resultSet = this.getResultSet();
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    this.c.checkEndTransaction();
                    throw throwable;
                }
            }
            this.c.checkEndTransaction();
            return resultSet2;
        }
        Object var3_4 = null;
        this.c.checkEndTransaction();
        return resultSet;
    }

    public int executeUpdate() throws SQLException {
        int n;
        try {
            this.c.ensureInTransaction();
            if (this.internalExecute(this.isExecuteProcedureStatement)) {
                throw new SQLException("update statement returned results!");
            }
            n = this.getUpdateCount();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.c.checkEndTransaction();
            throw throwable;
        }
        this.c.checkEndTransaction();
        return n;
    }

    protected FBField getField(int columnIndex) throws SQLException {
        if (columnIndex > this.fields.length) {
            throw new SQLException("invalid column index");
        }
        this.isParamSet[columnIndex - 1] = true;
        return this.fields[columnIndex - 1];
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new FBResultSetMetaData(this.fixedStmt.getOutSqlda().sqlvar, this.c);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    protected XSQLVAR getXsqlvar(int columnIndex) {
        return this.fixedStmt.getInSqlda().sqlvar[columnIndex - 1];
    }

    protected boolean internalExecute(boolean sendOutParams) throws SQLException {
        boolean canExecute = true;
        int i = 0;
        while (i < this.isParamSet.length) {
            canExecute = canExecute && this.isParamSet[i];
            ++i;
        }
        if (!canExecute) {
            throw new SQLException("Not all parameters were set. Cannot execute query.");
        }
        if (this.hasBlobs) {
            int i2 = 0;
            while (i2 < this.isParamSet.length) {
                if (this.isBlob[i2]) {
                    FBFlushableField flushableField = (FBFlushableField)((Object)this.getField(i2 + 1));
                    flushableField.flushCachedData();
                }
                ++i2;
            }
        }
        try {
            this.closeResultSet();
            this.c.executeStatement(this.fixedStmt, sendOutParams);
            this.isResultSet = this.fixedStmt.getOutSqlda().sqld > 0;
            return this.fixedStmt.getOutSqlda().sqld > 0;
        }
        catch (GDSException ge) {
            throw new FBSQLException(ge);
        }
    }

    protected void prepareFixedStatement(String sql, boolean describeBind) throws GDSException, SQLException {
        super.prepareFixedStatement(sql, describeBind);
        XSQLDA inSqlda = this.fixedStmt.getInSqlda();
        if (!describeBind && inSqlda == null) {
            inSqlda = new XSQLDA();
            inSqlda.sqln = 0;
            inSqlda.sqlvar = new XSQLVAR[0];
        }
        this.isParamSet = new boolean[inSqlda.sqln];
        this.fields = new FBField[inSqlda.sqln];
        this.isBlob = new boolean[inSqlda.sqln];
        XSQLVAR[] inVars = inSqlda.sqlvar;
        int i = 0;
        while (i < this.isParamSet.length) {
            this.isParamSet[i] = false;
            this.fields[i] = FBField.createField(this.getXsqlvar(i + 1), null, i, false);
            if (this.fields[i] instanceof FBBlobField) {
                ((FBBlobField)this.fields[i]).setConnection(this.c);
            } else if (this.fields[i] instanceof FBStringField) {
                ((FBStringField)this.fields[i]).setConnection(this.c);
            }
            boolean bl = this.isBlob[i] = FBField.isType(this.getXsqlvar(i + 1), 2004) || FBField.isType(this.getXsqlvar(i + 1), -2) || FBField.isType(this.getXsqlvar(i + 1), -1);
            if (this.isBlob[i]) {
                this.hasBlobs = true;
            }
            ++i;
        }
        this.isExecuteProcedureStatement = this.isExecuteProcedureStatement(sql);
    }

    public void setArray(int i, Array x) throws SQLException {
        throw new SQLException("Arrays are not supported.");
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.getField(parameterIndex).setBigDecimal(x);
    }

    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.getField(parameterIndex).setBinaryStream(inputStream, length);
    }

    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        if (!(blob instanceof FBBlob)) {
            throw new SQLException("You must use FBBlobs with Firebird!");
        }
        this.getField(parameterIndex).setBlob((FBBlob)blob);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.getField(parameterIndex).setBoolean(x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.getField(parameterIndex).setByte(x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.getField(parameterIndex).setBytes(x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.getField(parameterIndex).setCharacterStream(reader, length);
    }

    public void setClob(int i, Clob x) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.getField(parameterIndex).setDate(x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setDate(x, cal);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.getField(parameterIndex).setDouble(x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.getField(parameterIndex).setFloat(x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.getField(parameterIndex).setInteger(x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.getField(parameterIndex).setLong(x);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (parameterIndex > this.fields.length) {
            throw new SQLException("invalid column index");
        }
        this.getField(parameterIndex).setNull();
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.getField(parameterIndex).setObject(x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.getField(parameterIndex).setShort(x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.getField(parameterIndex).setString(x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.getField(parameterIndex).setTime(x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setTime(x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.getField(parameterIndex).setTimestamp(x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setTimestamp(x, cal);
    }

    public void setURL(int param1, URL param2) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }
}

