/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBField;
import org.firebirdsql.jdbc.FBResultSet;

class FBIntegerField
extends FBField {
    FBIntegerField(XSQLVAR field, FBResultSet rs, int numCol) throws SQLException {
        super(field, rs, numCol);
    }

    BigDecimal getBigDecimal() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return BigDecimal.valueOf(XSQLVAR.decodeInt(this.rs.row[this.numCol]));
    }

    boolean getBoolean() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return false;
        }
        return XSQLVAR.decodeInt(this.rs.row[this.numCol]) == 1;
    }

    byte getByte() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Integer value = new Integer(XSQLVAR.decodeInt(this.rs.row[this.numCol]));
        if (value > 127 || value < -128) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.BYTE_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        return value.byteValue();
    }

    double getDouble() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0;
        }
        return XSQLVAR.decodeInt(this.rs.row[this.numCol]);
    }

    float getFloat() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0f;
        }
        return XSQLVAR.decodeInt(this.rs.row[this.numCol]);
    }

    int getInt() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        return XSQLVAR.decodeInt(this.rs.row[this.numCol]);
    }

    long getLong() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0L;
        }
        return XSQLVAR.decodeInt(this.rs.row[this.numCol]);
    }

    Object getObject() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return new Integer(XSQLVAR.decodeInt(this.rs.row[this.numCol]));
    }

    short getShort() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Integer value = new Integer(XSQLVAR.decodeInt(this.rs.row[this.numCol]));
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.BYTE_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        return value.shortValue();
    }

    String getString() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return String.valueOf(XSQLVAR.decodeInt(this.rs.row[this.numCol]));
    }

    void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        if (value.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) > 0 || value.compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) < 0) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.BIGDECIMAL_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        this.setInteger(value.intValue());
    }

    void setBoolean(boolean value) throws SQLException {
        this.setInteger(value ? 1 : 0);
    }

    void setByte(byte value) throws SQLException {
        this.setInteger(value);
    }

    void setDouble(double value) throws SQLException {
        if (value > 2.147483647E9 || value < -2.147483648E9) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.DOUBLE_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        this.setInteger((int)value);
    }

    void setFloat(float value) throws SQLException {
        if (value > 2.1474836E9f || value < -2.1474836E9f) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.FLOAT_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        this.setInteger((int)value);
    }

    void setInteger(int value) throws SQLException {
        this.field.sqldata = XSQLVAR.encodeInt(value);
    }

    void setLong(long value) throws SQLException {
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.LONG_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        this.setInteger((int)value);
    }

    void setShort(short value) throws SQLException {
        this.setInteger(value);
    }

    void setString(String value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        try {
            this.setInteger(Integer.parseInt(value));
        }
        catch (NumberFormatException numberFormatException) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.INT_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
    }
}

