/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.security.auth.Subject;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jca.FBTpbMapper;
import org.firebirdsql.jdbc.FBConnectionHelper;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class FBDriver
implements Driver {
    private static final Logger log;
    public static final String FIREBIRD_PROTOCOL = "jdbc:firebirdsql:";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String DATABASE = "database";
    public static final String BLOB_BUFFER_LENGTH = "blob_buffer_length";
    public static final String TPB_MAPPING = "tpb_mapping";
    private Subject subject = null;
    private Map mcfToDataSourceMap = new HashMap();
    static /* synthetic */ Class class$org$firebirdsql$jdbc$FBDriver;

    static {
        block2: {
            log = LoggerFactory.getLogger(class$org$firebirdsql$jdbc$FBDriver != null ? class$org$firebirdsql$jdbc$FBDriver : (class$org$firebirdsql$jdbc$FBDriver = FBDriver.class$("org.firebirdsql.jdbc.FBDriver")), false);
            try {
                DriverManager.registerDriver(new FBDriver());
            }
            catch (Exception ex) {
                if (log == null) break block2;
                log.error("Could not register with driver manager", ex);
            }
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(FIREBIRD_PROTOCOL);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null || !url.startsWith(FIREBIRD_PROTOCOL)) {
            return null;
        }
        Integer blobBufferLength = null;
        try {
            int iQuestionMark = url.indexOf("?");
            if (iQuestionMark > -1) {
                if (info == null) {
                    info = new Properties();
                }
                String propString = url.substring(iQuestionMark + 1);
                StringTokenizer st = new StringTokenizer(propString, "&");
                while (st.hasMoreTokens()) {
                    String propertyString = st.nextToken();
                    int iIs = propertyString.indexOf("=");
                    if (iIs <= -1) continue;
                    String property = propertyString.substring(0, iIs);
                    String value = propertyString.substring(iIs + 1);
                    info.setProperty(property, value);
                    if (!property.equals(BLOB_BUFFER_LENGTH)) continue;
                    try {
                        blobBufferLength = new Integer(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SQLException("Blob buffer length " + value + " could not be converted to an integer");
                    }
                }
                url = url.substring(0, iQuestionMark);
            }
            FBConnectionRequestInfo conCri = FBConnectionHelper.getCri(info, FBConnectionHelper.getDefaultCri());
            FBTpbMapper tpbMapper = FBConnectionHelper.getTpbMapper(info);
            String user = info.getProperty(USER);
            if (user == null) {
                user = conCri.getStringProperty(28);
            }
            if (user == null) {
                throw new SQLException("User for database connection not specified.");
            }
            String password = info.getProperty(PASSWORD);
            if (password == null) {
                password = conCri.getStringProperty(29);
            }
            if (password == null) {
                throw new SQLException("Password for database connection not specified.");
            }
            String databaseURL = url.substring(FIREBIRD_PROTOCOL.length());
            FBManagedConnectionFactory mcf = new FBManagedConnectionFactory();
            mcf.setDatabase(databaseURL);
            mcf.setConnectionRequestInfo(conCri);
            if (tpbMapper != null) {
                mcf.setTpbMapper(tpbMapper);
            }
            if (blobBufferLength != null) {
                mcf.setBlobBufferLength(blobBufferLength);
            }
            mcf = mcf.canonicalize();
            FBDataSource dataSource = null;
            Map map = this.mcfToDataSourceMap;
            synchronized (map) {
                dataSource = (FBDataSource)this.mcfToDataSourceMap.get(mcf);
                if (dataSource == null) {
                    dataSource = (FBDataSource)mcf.createConnectionFactory();
                    this.mcfToDataSourceMap.put(mcf, dataSource);
                }
            }
            return dataSource.getConnection(user, password);
        }
        catch (ResourceException resex) {
            throw new SQLException(resex.getMessage());
        }
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 1;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DriverPropertyInfo dinfo;
        Vector<DriverPropertyInfo> properties = new Vector<DriverPropertyInfo>();
        String database = url.substring(FIREBIRD_PROTOCOL.length());
        String user = info.getProperty(USER);
        String passwd = info.getProperty(PASSWORD);
        if (database != null && database != "") {
            dinfo = new DriverPropertyInfo(DATABASE, database);
            dinfo.required = true;
            properties.add(dinfo);
        }
        if (user != null) {
            dinfo = new DriverPropertyInfo(USER, user);
            dinfo.required = true;
            properties.add(dinfo);
        }
        if (passwd != null) {
            dinfo = new DriverPropertyInfo(PASSWORD, passwd);
            dinfo.required = true;
            properties.add(dinfo);
        }
        return properties.toArray(new DriverPropertyInfo[0]);
    }

    public boolean jdbcCompliant() {
        return false;
    }
}

