/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.isc_blob_handle;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class FBBlob
implements Blob {
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$jdbc$FBBlob != null ? class$org$firebirdsql$jdbc$FBBlob : (class$org$firebirdsql$jdbc$FBBlob = FBBlob.class$("org.firebirdsql.jdbc.FBBlob")), false);
    private int bufferlength;
    private long blob_id;
    private FBConnection c;
    private boolean isNew;
    private Collection inputStreams = new HashSet();
    private FBBlobOutputStream blobOut = null;
    static /* synthetic */ Class class$org$firebirdsql$jdbc$FBBlob;

    FBBlob(FBConnection c) {
        this(c, true);
    }

    FBBlob(FBConnection c, long blob_id) {
        this(c, false);
        this.blob_id = blob_id;
    }

    private FBBlob(FBConnection c, boolean isNew) {
        this.c = c;
        this.isNew = isNew;
        this.bufferlength = c.getBlobBufferLength();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    void close() throws IOException {
        Iterator i = this.inputStreams.iterator();
        while (i.hasNext()) {
            ((FBBlobInputStream)i.next()).close();
        }
        this.inputStreams.clear();
    }

    void copyCharacterStream(Reader inputStream, int length) throws SQLException {
        OutputStream os = this.setBinaryStream(0L);
        OutputStreamWriter osw = new OutputStreamWriter(os);
        char[] buffer = new char[this.bufferlength];
        try {
            while (length > 0) {
                int chunk = inputStream.read(buffer, 0, length < this.bufferlength ? length : this.bufferlength);
                osw.write(buffer, 0, chunk);
                length -= chunk;
            }
            os.close();
        }
        catch (IOException ioe) {
            throw new SQLException("read/write blob problem: " + ioe);
        }
    }

    void copyStream(InputStream inputStream, int length) throws SQLException {
        OutputStream os = this.setBinaryStream(0L);
        byte[] buffer = new byte[this.bufferlength];
        try {
            while (length > 0) {
                int chunk = inputStream.read(buffer, 0, length < this.bufferlength ? length : this.bufferlength);
                os.write(buffer, 0, chunk);
                length -= chunk;
            }
            os.close();
        }
        catch (IOException ioe) {
            throw new SQLException("read/write blob problem: " + ioe);
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        class Org_firebirdsql_jdbc_FBBlob$1 {
            /* synthetic */ Org_firebirdsql_jdbc_FBBlob$1() {
            }
        }
        FBBlobInputStream blobstream = new FBBlobInputStream();
        this.inputStreams.add(blobstream);
        return new BufferedInputStream(blobstream, this.bufferlength);
    }

    long getBlobId() throws SQLException {
        if (this.isNew) {
            throw new SQLException("you are attempting to access an blob with no blob_id");
        }
        return this.blob_id;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public long length() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public long position(Blob pattern, long start) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public long position(byte[] pattern, long start) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (this.blobOut != null) {
            throw new SQLException("only one blob output stream open at a time!");
        }
        if (pos < 0L) {
            throw new SQLException("You can't start before the beginning of the blob");
        }
        if (this.isNew && pos > 0L) {
            throw new SQLException("previous value was null, you must start at position 0");
        }
        this.blobOut = new FBBlobOutputStream();
        return new BufferedOutputStream(this.blobOut, this.bufferlength);
    }

    public int setBytes(long param1, byte[] param2) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public int setBytes(long param1, byte[] param2, int param3, int param4) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void truncate(long param1) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public class FBBlobInputStream
    extends InputStream {
        private byte[] buffer = null;
        private isc_blob_handle blob;
        private int pos = 0;
        private boolean closed = false;

        private FBBlobInputStream() throws SQLException {
            if (FBBlob.this.isNew) {
                throw new SQLException("You can't read a new blob");
            }
            try {
                this.blob = FBBlob.this.c.openBlobHandle(FBBlob.this.blob_id);
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
        }

        public int available() throws IOException {
            this.checkClosed();
            if (this.buffer == null) {
                if (this.blob.isEof()) {
                    return -1;
                }
                try {
                    this.buffer = FBBlob.this.c.getBlobSegment(this.blob, FBBlob.this.bufferlength);
                }
                catch (GDSException ge) {
                    throw new IOException("Blob read problem: " + ge.toString());
                }
                this.pos = 0;
                if (this.buffer.length == 0) {
                    return -1;
                }
            }
            return this.buffer.length - this.pos;
        }

        private void checkClosed() throws IOException {
            if (this.closed) {
                throw new IOException("Input stream is already closed.");
            }
        }

        public void close() throws IOException {
            if (this.blob != null) {
                try {
                    FBBlob.this.c.closeBlob(this.blob);
                }
                catch (GDSException ge) {
                    throw new IOException("couldn't close blob: " + ge);
                }
                this.blob = null;
                this.closed = true;
            }
        }

        public int read() throws IOException {
            this.checkClosed();
            if (this.available() <= 0) {
                return -1;
            }
            int result = this.buffer[this.pos++] & 0xFF;
            if (this.pos == this.buffer.length) {
                this.buffer = null;
            }
            return result;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.checkClosed();
            int result = this.available();
            if (result <= 0) {
                return -1;
            }
            if (result > len) {
                System.arraycopy(this.buffer, this.pos, b, off, len);
                this.pos += len;
                return len;
            }
            System.arraycopy(this.buffer, this.pos, b, off, result);
            this.buffer = null;
            this.pos = 0;
            return result;
        }
    }

    private class FBBlobOutputStream
    extends OutputStream {
        private isc_blob_handle blob;
        private byte[] buffer = null;

        private FBBlobOutputStream() throws SQLException {
            try {
                this.blob = FBBlob.this.c.createBlobHandle();
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
            if (FBBlob.this.isNew) {
                FBBlob.this.blob_id = this.blob.getBlob_id();
                FBBlob.this.isNew = false;
            }
        }

        public void close() throws IOException {
            if (this.blob != null) {
                try {
                    FBBlob.this.c.closeBlob(this.blob);
                    FBBlob.this.blob_id = this.blob.getBlob_id();
                    FBBlob.this.isNew = false;
                }
                catch (GDSException ge) {
                    throw new IOException("could not close blob: " + ge);
                }
                this.blob = null;
            }
        }

        public void write(int b) throws IOException {
            throw new IOException("FBBlobOutputStream.write(int b) not implemented");
        }

        public void write(byte[] b, int off, int len) throws IOException {
            try {
                byte[] buf = new byte[FBBlob.this.bufferlength];
                while (len > 0) {
                    int chunk;
                    if (len >= FBBlob.this.bufferlength) {
                        if (buf == null) {
                            buf = new byte[FBBlob.this.bufferlength];
                        }
                        chunk = FBBlob.this.bufferlength;
                    } else {
                        buf = new byte[len];
                        chunk = len;
                    }
                    System.arraycopy(b, off, buf, 0, chunk);
                    FBBlob.this.c.putBlobSegment(this.blob, buf);
                    len -= chunk;
                }
            }
            catch (GDSException ge) {
                throw new IOException("Problem writing to FBBlobOutputStream: " + ge);
            }
        }
    }
}

