/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBField;
import org.firebirdsql.jdbc.FBResultSet;

public class FBBigDecimalField
extends FBField {
    private static final BigInteger MAX_SHORT = BigInteger.valueOf(32767L);
    private static final BigInteger MIN_SHORT = BigInteger.valueOf(-32768L);
    private static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    private int fieldType = 0;

    FBBigDecimalField(XSQLVAR field, FBResultSet rs, int numCol, int fieldType) throws SQLException {
        super(field, rs, numCol);
        this.fieldType = fieldType;
    }

    BigDecimal getBigDecimal() throws SQLException {
        long longValue;
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        if (this.fieldType == 2) {
            longValue = XSQLVAR.decodeInt(this.rs.row[this.numCol]);
        } else if (this.fieldType == 3) {
            longValue = XSQLVAR.decodeLong(this.rs.row[this.numCol]);
        } else if (this.fieldType == 1) {
            longValue = XSQLVAR.decodeShort(this.rs.row[this.numCol]);
        } else {
            throw (SQLException)FBField.createException(FBField.BIGDECIMAL_CONVERSION_ERROR).fillInStackTrace();
        }
        return BigDecimal.valueOf(longValue, -this.field.sqlscale);
    }

    boolean getBoolean() throws SQLException {
        return this.getByte() == 1;
    }

    byte getByte() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        long longValue = this.getLong();
        if (longValue > 127L || longValue < -128L) {
            throw (SQLException)FBField.createException(FBField.BYTE_CONVERSION_ERROR).fillInStackTrace();
        }
        return (byte)longValue;
    }

    double getDouble() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0;
        }
        return this.getBigDecimal().doubleValue();
    }

    float getFloat() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0f;
        }
        double doubleValue = this.getDouble();
        if (doubleValue > 3.4028234663852886E38 || doubleValue < -3.4028234663852886E38) {
            throw (SQLException)FBField.createException(FBField.FLOAT_CONVERSION_ERROR).fillInStackTrace();
        }
        return (float)doubleValue;
    }

    int getInt() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        long longValue = this.getLong();
        if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
            throw (SQLException)FBField.createException(FBField.INT_CONVERSION_ERROR).fillInStackTrace();
        }
        return (int)longValue;
    }

    long getLong() throws SQLException {
        return this.getBigDecimal().longValue();
    }

    Object getObject() throws SQLException {
        return this.getBigDecimal();
    }

    short getShort() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        long longValue = this.getLong();
        if (longValue > 32767L || longValue < -32768L) {
            throw (SQLException)FBField.createException(FBField.SHORT_CONVERSION_ERROR).fillInStackTrace();
        }
        return (short)longValue;
    }

    String getString() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return this.getBigDecimal().toString();
    }

    void setBigDecimal(BigDecimal value) throws SQLException {
        value = value.setScale(-this.field.sqlscale, 4);
        if (this.fieldType == 1) {
            if (value.unscaledValue().compareTo(MAX_SHORT) > 0 || value.unscaledValue().compareTo(MIN_SHORT) < 0) {
                throw (SQLException)FBField.createException(FBField.BIGDECIMAL_CONVERSION_ERROR).fillInStackTrace();
            }
            this.field.sqldata = XSQLVAR.encodeShort(value.unscaledValue().shortValue());
        } else if (this.fieldType == 2) {
            if (value.unscaledValue().compareTo(MAX_INT) > 0 || value.unscaledValue().compareTo(MIN_INT) < 0) {
                throw (SQLException)FBField.createException(FBField.BIGDECIMAL_CONVERSION_ERROR).fillInStackTrace();
            }
            this.field.sqldata = XSQLVAR.encodeInt(value.unscaledValue().intValue());
        } else if (this.fieldType == 3) {
            if (value.unscaledValue().compareTo(MAX_LONG) > 0 || value.unscaledValue().compareTo(MIN_LONG) < 0) {
                throw (SQLException)FBField.createException(FBField.BIGDECIMAL_CONVERSION_ERROR).fillInStackTrace();
            }
            this.field.sqldata = XSQLVAR.encodeLong(value.unscaledValue().longValue());
        } else {
            throw (SQLException)FBField.createException(FBField.BIGDECIMAL_CONVERSION_ERROR).fillInStackTrace();
        }
    }

    void setBoolean(boolean value) throws SQLException {
        this.setInteger(value ? 1 : 0);
    }

    void setByte(byte value) throws SQLException {
        this.setLong(value);
    }

    void setDouble(double value) throws SQLException {
        this.setBigDecimal(new BigDecimal(Double.toString(value)));
    }

    void setFloat(float value) throws SQLException {
        this.setDouble(value);
    }

    void setInteger(int value) throws SQLException {
        this.setLong(value);
    }

    void setLong(long value) throws SQLException {
        this.setBigDecimal(BigDecimal.valueOf(value, 0));
    }

    void setShort(short value) throws SQLException {
        this.setLong(value);
    }

    void setString(String value) throws SQLException {
        try {
            this.setBigDecimal(new BigDecimal(value));
        }
        catch (NumberFormatException numberFormatException) {
            throw (SQLException)FBField.createException(FBField.STRING_CONVERSION_ERROR).fillInStackTrace();
        }
    }
}

