/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import org.firebirdsql.gds.GDSExceptionHelper;
import org.firebirdsql.gds.ISCConstants;

public class GDSException
extends Exception {
    protected int type;
    protected int intParam;
    protected String strParam;
    protected int xaErrorCode;
    protected GDSException next;

    public GDSException(int fbErrorCode) {
        this.intParam = fbErrorCode;
        this.type = 1;
    }

    public GDSException(int type, int intParam) {
        this.type = type;
        this.intParam = intParam;
    }

    public GDSException(int type, int fbErrorCode, String strParam) {
        this.type = type;
        this.intParam = fbErrorCode;
        this.setNext(new GDSException(2, strParam));
    }

    public GDSException(int type, String strParam) {
        this.type = type;
        this.strParam = strParam;
    }

    public GDSException(String message) {
        super(message);
        this.type = 2;
    }

    public static GDSException createWithXAErrorCode(String message, int xaErrorCode) {
        GDSException gdse = new GDSException(message);
        gdse.setXAErrorCode(xaErrorCode);
        return gdse;
    }

    public int getFbErrorCode() {
        if (this.type == 4) {
            return this.intParam;
        }
        return -1;
    }

    public int getIntParam() {
        return this.intParam;
    }

    public String getMessage() {
        String msg;
        GDSException child = this.next;
        if (this.type == 1 || this.type == 18) {
            GDSExceptionHelper.GDSMessage message = GDSExceptionHelper.getMessage(this.intParam);
            int paramCount = message.getParamCount();
            int i = 0;
            while (i < paramCount) {
                if (child == null) break;
                message.setParameter(i, child.getParam());
                child = child.next;
                ++i;
            }
            msg = message.toString();
        } else {
            msg = super.getMessage();
        }
        if (child != null) {
            msg = String.valueOf(msg) + "\n" + child.getMessage();
        }
        return msg;
    }

    public GDSException getNext() {
        return this.next;
    }

    protected String getParam() {
        if (this.type == 5 || this.type == 2) {
            return this.strParam;
        }
        if (this.type == 4) {
            return String.valueOf(this.intParam);
        }
        return "";
    }

    public int getXAErrorCode() {
        return this.xaErrorCode;
    }

    public boolean isFatal() {
        return this.isThisFatal() || this.next != null && this.next.isFatal();
    }

    private boolean isThisFatal() {
        int i = 0;
        while (i < ISCConstants.FATAL_ERRORS.length && this.intParam >= ISCConstants.FATAL_ERRORS[i]) {
            if (this.intParam == ISCConstants.FATAL_ERRORS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isWarning() {
        return this.type == 18;
    }

    public void setNext(GDSException e) {
        this.next = e;
    }

    public void setXAErrorCode(int xaErrorCode) {
        this.xaErrorCode = xaErrorCode;
    }
}

