/*
 * Decompiled with CFR 0.152.
 */
package networkconsole.ui;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import networkconsole.datamodel.EntryListException;
import networkconsole.datamodel.JdbcEntry;
import networkconsole.datamodel.swt.providers.JdbcEntryListProvider;
import networkconsole.swt.extensions.ExtendedTableViewer;
import networkconsole.ui.NetworkConsoleWindow;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TrafficDialog
extends Dialog {
    private ExtendedTableViewer viewer;
    private Text textBegin;
    private Text textEnd;
    private Text queryText;

    public TrafficDialog(Shell shell, Text text) {
        super(shell);
        this.queryText = text;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new FormLayout());
        GridData gridData = new GridData(1808);
        gridData.widthHint = 400;
        composite3.setLayoutData((Object)gridData);
        Composite composite4 = new Composite(composite3, 0);
        composite4.setLayout((Layout)new GridLayout());
        FormData formData = new FormData();
        formData.bottom = new FormAttachment(100, 5);
        formData.right = new FormAttachment(100, 5);
        formData.top = new FormAttachment(0, -5);
        formData.left = new FormAttachment(0, -5);
        composite4.setLayoutData((Object)formData);
        this.setupReports(composite4);
        this.setupPeriod(composite4);
        return composite2;
    }

    private void setupPeriod(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 7;
        gridLayout.marginHeight = 7;
        gridLayout.horizontalSpacing = 15;
        group.setLayout((Layout)gridLayout);
        group.setText(NetworkConsoleWindow.translate("ui.dialog.traffic.period"));
        new Label((Composite)group, 0).setText(NetworkConsoleWindow.translate("ui.dialog.traffic.period.begin"));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -1);
        calendar.add(2, -1);
        this.textBegin = new Text((Composite)group, 2048);
        this.textBegin.setText(simpleDateFormat.format(calendar.getTime()));
        new Label((Composite)group, 0).setText(NetworkConsoleWindow.translate("ui.dialog.traffic.period.end"));
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(6, -1);
        this.textEnd = new Text((Composite)group, 2048);
        this.textEnd.setText(simpleDateFormat.format(calendar2.getTime()));
    }

    private void setupReports(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        group.setText(NetworkConsoleWindow.translate("ui.dialog.traffic.reports"));
        this.viewer = new ExtendedTableViewer((Composite)group, 67584);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 100;
        this.viewer.getTable().setLayoutData((Object)gridData);
        this.setupReportsTable(this.viewer);
    }

    private void setupReportsTable(ExtendedTableViewer extendedTableViewer) {
        JdbcEntryListProvider jdbcEntryListProvider = new JdbcEntryListProvider();
        extendedTableViewer.setContentProvider(jdbcEntryListProvider);
        extendedTableViewer.setColumnProvider(jdbcEntryListProvider);
        extendedTableViewer.setLabelProvider(jdbcEntryListProvider);
        extendedTableViewer.setInput(NetworkConsoleWindow.proceduresList);
        extendedTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                TrafficDialog.this.getButton(0).setEnabled(!selectionChangedEvent.getSelection().isEmpty());
            }
        });
        if (NetworkConsoleWindow.properties.getProperty("ui.view.traffic.translate").equals("true")) {
            try {
                NetworkConsoleWindow.proceduresList.refresh();
            }
            catch (EntryListException entryListException) {
                MessageDialog.openError(this.getShell(), this.getShell().getText(), "[" + entryListException.getClass().getName() + "] " + entryListException.getLocalizedMessage());
                entryListException.printStackTrace();
            }
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, NetworkConsoleWindow.translate("ui.dialog.ok"), true).setEnabled(false);
        this.createButton(composite, 1, NetworkConsoleWindow.translate("ui.dialog.cancel"), false);
    }

    protected void okPressed() {
        try {
            JdbcEntry jdbcEntry = (JdbcEntry)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            this.queryText.setText("-- " + jdbcEntry.getField(1) + Text.DELIMITER + "select * from " + jdbcEntry.getField(0).toLowerCase() + "('" + this.textBegin.getText() + "','" + this.textEnd.getText() + "')");
            super.okPressed();
        }
        catch (Exception exception) {
            MessageDialog.openError(this.getShell(), this.getShell().getText(), "[" + exception.getClass().getName() + "] " + exception.getLocalizedMessage());
            exception.printStackTrace();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NetworkConsoleWindow.translate("ui.dialog.traffic.caption"));
    }
}

