/*
 * Decompiled with CFR 0.152.
 */
package networkconsole.ui;

import javax.xml.transform.sax.SAXSource;
import networkconsole.datamodel.EntryListException;
import networkconsole.datamodel.LdapUserEntry;
import networkconsole.datamodel.sax.LdapEntryListInputSource;
import networkconsole.datamodel.sax.LdapEntryListXMLReader;
import networkconsole.datamodel.swt.dialogs.EntryDialog;
import networkconsole.datamodel.swt.providers.LdapEntryListProvider;
import networkconsole.swt.extensions.ExtendedTableViewer;
import networkconsole.ui.INetworkConsoleView;
import networkconsole.ui.NetworkConsoleWindow;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

public class NetworkUsersView
extends CTabItem
implements INetworkConsoleView {
    private NetworkConsoleWindow window;
    private ExtendedTableViewer viewer;

    private void setActionsEnabled() {
        this.window.setActionsEnabled();
    }

    public NetworkUsersView(NetworkConsoleWindow networkConsoleWindow, Menu menu) {
        super(networkConsoleWindow.tabFolder, 0);
        this.window = networkConsoleWindow;
        this.setImage(ImageDescriptor.createFromFile(this.getClass(), "images/users.gif").createImage());
        this.setText(NetworkConsoleWindow.translate("ui.view.users.caption"));
        this.viewer = new ExtendedTableViewer((Composite)networkConsoleWindow.tabFolder, 67584);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                NetworkUsersView.this.setActionsEnabled();
            }
        });
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        if (menu != null) {
            this.viewer.getTable().setMenu(menu);
        }
        LdapEntryListProvider ldapEntryListProvider = new LdapEntryListProvider();
        this.viewer.setContentProvider(ldapEntryListProvider);
        this.viewer.setColumnProvider(ldapEntryListProvider);
        this.viewer.setLabelProvider(ldapEntryListProvider);
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput(NetworkConsoleWindow.users);
        this.setControl(this.viewer.getControl());
    }

    public SAXSource export() {
        return new SAXSource(new LdapEntryListXMLReader(), new LdapEntryListInputSource(NetworkConsoleWindow.translate("ui.view.users.caption"), NetworkConsoleWindow.users));
    }

    public void refresh() {
        try {
            NetworkConsoleWindow.users.refresh();
        }
        catch (EntryListException entryListException) {
            entryListException.printStackTrace();
        }
    }

    public void add() {
        EntryDialog entryDialog = new EntryDialog(this.window.getShell(), NetworkConsoleWindow.users, null);
        entryDialog.open();
    }

    public void edit() {
        LdapUserEntry ldapUserEntry = (LdapUserEntry)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        EntryDialog entryDialog = new EntryDialog(this.window.getShell(), NetworkConsoleWindow.users, ldapUserEntry);
        entryDialog.open();
    }

    public void query() {
    }

    public void remove() {
        try {
            LdapUserEntry ldapUserEntry = (LdapUserEntry)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            NetworkConsoleWindow.users.remove(ldapUserEntry);
        }
        catch (EntryListException entryListException) {
            MessageDialog.openError(this.window.getShell(), this.window.getShell().getText(), "Remove error: " + entryListException);
        }
    }

    public boolean isAddEnabled() {
        return true;
    }

    public boolean isEditEnabled() {
        return !((IStructuredSelection)this.viewer.getSelection()).isEmpty();
    }

    public boolean isQueryEnabled() {
        return false;
    }

    public boolean isRemoveEnabled() {
        return !((IStructuredSelection)this.viewer.getSelection()).isEmpty();
    }
}

