/*
 * Decompiled with CFR 0.152.
 */
package networkconsole.ui;

import javax.xml.transform.sax.SAXSource;
import networkconsole.datamodel.EntryListException;
import networkconsole.datamodel.sax.JdbcEntryListInputSource;
import networkconsole.datamodel.sax.JdbcEntryListXMLReader;
import networkconsole.datamodel.swt.providers.JdbcEntryListProvider;
import networkconsole.swt.extensions.ExtendedTableViewer;
import networkconsole.ui.INetworkConsoleView;
import networkconsole.ui.NetworkConsoleWindow;
import networkconsole.ui.TrafficDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NetworkTrafficView
extends CTabItem
implements INetworkConsoleView {
    private NetworkConsoleWindow window;
    private Text queryText;
    private Text messagesText;

    public NetworkTrafficView(NetworkConsoleWindow networkConsoleWindow) {
        super(networkConsoleWindow.tabFolder, 0);
        this.window = networkConsoleWindow;
        this.setImage(ImageDescriptor.createFromFile(this.getClass(), "images/traffic.gif").createImage());
        this.setText(NetworkConsoleWindow.translate("ui.view.traffic.caption"));
        Composite composite = new Composite((Composite)networkConsoleWindow.tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(composite, 512);
        this.queryText = new Text((Composite)sashForm, 2882);
        this.queryText.setFont(new Font((Device)composite.getDisplay(), NetworkConsoleWindow.properties.getProperty("ui.view.traffic.editor.font.name"), new Integer(NetworkConsoleWindow.properties.getProperty("ui.view.traffic.editor.font.size")).intValue(), 0));
        ExtendedTableViewer extendedTableViewer = new ExtendedTableViewer((Composite)sashForm, 67584);
        this.messagesText = new Text((Composite)sashForm, 2890);
        this.messagesText.setEditable(false);
        sashForm.setWeights(new int[]{1, 4, 1});
        this.setControl((Control)composite);
        JdbcEntryListProvider jdbcEntryListProvider = new JdbcEntryListProvider();
        extendedTableViewer.setContentProvider(jdbcEntryListProvider);
        extendedTableViewer.setColumnProvider(jdbcEntryListProvider);
        extendedTableViewer.setLabelProvider(jdbcEntryListProvider);
        extendedTableViewer.setInput(NetworkConsoleWindow.queryList);
    }

    public SAXSource export() {
        String string = this.queryText.getText();
        String string2 = string.startsWith("-- ") ? string.substring(3, string.indexOf(Text.DELIMITER)) : NetworkConsoleWindow.translate("ui.view.traffic.caption");
        return new SAXSource(new JdbcEntryListXMLReader(), new JdbcEntryListInputSource(string2, NetworkConsoleWindow.queryList));
    }

    public void refresh() {
        try {
            NetworkConsoleWindow.queryList.setSql(this.queryText.getText());
            this.messagesText.setText(NetworkConsoleWindow.translate("ui.view.traffic.message.success"));
        }
        catch (EntryListException entryListException) {
            this.messagesText.setText("[" + entryListException.getClass().getName() + "] " + entryListException.getLocalizedMessage());
            entryListException.printStackTrace();
        }
    }

    public void add() {
    }

    public void edit() {
    }

    public void query() {
        TrafficDialog trafficDialog = new TrafficDialog(this.window.getShell(), this.queryText);
        trafficDialog.open();
    }

    public void remove() {
    }

    public boolean isAddEnabled() {
        return false;
    }

    public boolean isEditEnabled() {
        return false;
    }

    public boolean isQueryEnabled() {
        return true;
    }

    public boolean isRemoveEnabled() {
        return false;
    }
}

