/*
 * Decompiled with CFR 0.152.
 */
package networkconsole.ui;

import javax.xml.transform.sax.SAXSource;
import networkconsole.datamodel.EntryListException;
import networkconsole.datamodel.LdapHostEntry;
import networkconsole.datamodel.sax.LdapEntryListInputSource;
import networkconsole.datamodel.sax.LdapEntryListXMLReader;
import networkconsole.datamodel.swt.dialogs.EntryDialog;
import networkconsole.datamodel.swt.providers.LdapEntryListProvider;
import networkconsole.swt.extensions.ExtendedTableViewer;
import networkconsole.ui.INetworkConsoleView;
import networkconsole.ui.NetworkConsoleWindow;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

public class NetworkHostsView
extends CTabItem
implements INetworkConsoleView {
    private NetworkConsoleWindow window;
    private ExtendedTableViewer viewer;

    private void setActionsEnabled() {
        this.window.setActionsEnabled();
    }

    public NetworkHostsView(NetworkConsoleWindow networkConsoleWindow, Menu menu) {
        super(networkConsoleWindow.tabFolder, 0);
        this.window = networkConsoleWindow;
        this.setImage(ImageDescriptor.createFromFile(this.getClass(), "images/hosts.gif").createImage());
        this.setText(NetworkConsoleWindow.translate("ui.view.hosts.caption"));
        this.viewer = new ExtendedTableViewer((Composite)networkConsoleWindow.tabFolder, 67584);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                NetworkHostsView.this.setActionsEnabled();
            }
        });
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        if (menu != null) {
            this.viewer.getTable().setMenu(menu);
        }
        LdapEntryListProvider ldapEntryListProvider = new LdapEntryListProvider();
        this.viewer.setContentProvider(ldapEntryListProvider);
        this.viewer.setColumnProvider(ldapEntryListProvider);
        this.viewer.setLabelProvider(ldapEntryListProvider);
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput(NetworkConsoleWindow.hosts);
        this.setControl(this.viewer.getControl());
    }

    public SAXSource export() {
        return new SAXSource(new LdapEntryListXMLReader(), new LdapEntryListInputSource(NetworkConsoleWindow.translate("ui.view.hosts.caption"), NetworkConsoleWindow.hosts));
    }

    public void refresh() {
        try {
            NetworkConsoleWindow.hosts.refresh();
        }
        catch (EntryListException entryListException) {
            entryListException.printStackTrace();
        }
    }

    public void add() {
        EntryDialog entryDialog = new EntryDialog(this.window.getShell(), NetworkConsoleWindow.hosts, null);
        entryDialog.open();
    }

    public void edit() {
        LdapHostEntry ldapHostEntry = (LdapHostEntry)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        EntryDialog entryDialog = new EntryDialog(this.window.getShell(), NetworkConsoleWindow.hosts, ldapHostEntry);
        entryDialog.open();
    }

    public void query() {
    }

    public void remove() {
        try {
            LdapHostEntry ldapHostEntry = (LdapHostEntry)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            NetworkConsoleWindow.hosts.remove(ldapHostEntry);
        }
        catch (EntryListException entryListException) {
            MessageDialog.openError(this.window.getShell(), this.window.getShell().getText(), "Remove error: " + entryListException);
        }
    }

    public boolean isAddEnabled() {
        return true;
    }

    public boolean isEditEnabled() {
        return !((IStructuredSelection)this.viewer.getSelection()).isEmpty();
    }

    public boolean isQueryEnabled() {
        return false;
    }

    public boolean isRemoveEnabled() {
        return !((IStructuredSelection)this.viewer.getSelection()).isEmpty();
    }
}

