/*
 * Decompiled with CFR 0.152.
 */
package networkconsole.ui;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.transform.sax.SAXSource;
import networkconsole.datamodel.JdbcEntryList;
import networkconsole.datamodel.LdapHostEntryList;
import networkconsole.datamodel.LdapUserEntryList;
import networkconsole.datamodel.swt.dialogs.ExportDialog;
import networkconsole.ui.ConnectionDialog;
import networkconsole.ui.INetworkConsoleView;
import networkconsole.ui.NetworkHostsView;
import networkconsole.ui.NetworkTrafficView;
import networkconsole.ui.NetworkUsersView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NetworkConsoleWindow
extends ApplicationWindow {
    static LdapHostEntryList hosts;
    static LdapUserEntryList users;
    static JdbcEntryList queryList;
    static JdbcEntryList proceduresList;
    public static Properties properties;
    CTabFolder tabFolder;
    private CTabItem tabHostsView;
    private CTabItem tabUsersView;
    private CTabItem tabTrafficView;
    private RefreshAction refreshAction = new RefreshAction(this);
    private ExportAction exportAction = new ExportAction(this);
    private ExitAction exitAction = new ExitAction(this);
    private AboutAction aboutAction = new AboutAction(this);
    private AddAction addAction = new AddAction(this);
    private RemoveAction removeAction = new RemoveAction(this);
    private EditAction editAction = new EditAction(this);
    private QueryAction queryAction = new QueryAction(this);

    public NetworkConsoleWindow() {
        super(null);
        this.addMenuBar();
        this.addCoolBar(0x800040);
        this.addStatusLine();
    }

    protected CoolBarManager createCoolBarManager(int n) {
        CoolBarManager coolBarManager = new CoolBarManager(n);
        coolBarManager.add(this.createToolBarManager(n));
        return coolBarManager;
    }

    protected ToolBarManager createToolBarManager(int n) {
        ToolBarManager toolBarManager = new ToolBarManager(n);
        toolBarManager.add(this.exitAction);
        toolBarManager.add(new Separator());
        toolBarManager.add(this.exportAction);
        toolBarManager.add(this.refreshAction);
        toolBarManager.add(new Separator());
        toolBarManager.add(this.addAction);
        toolBarManager.add(this.editAction);
        toolBarManager.add(this.removeAction);
        toolBarManager.add(this.queryAction);
        toolBarManager.add(new Separator());
        toolBarManager.add(this.aboutAction);
        return toolBarManager;
    }

    protected MenuManager createMenuManager() {
        MenuManager menuManager = new MenuManager();
        MenuManager menuManager2 = new MenuManager(NetworkConsoleWindow.translate("ui.menu.file"));
        MenuManager menuManager3 = new MenuManager(NetworkConsoleWindow.translate("ui.menu.edit"));
        MenuManager menuManager4 = new MenuManager(NetworkConsoleWindow.translate("ui.menu.help"));
        menuManager.add(menuManager2);
        menuManager.add(menuManager3);
        menuManager.add(menuManager4);
        menuManager2.add(this.refreshAction);
        menuManager2.add(this.exportAction);
        menuManager2.add(new Separator());
        menuManager2.add(this.exitAction);
        menuManager3.add(this.addAction);
        menuManager3.add(this.editAction);
        menuManager3.add(this.removeAction);
        menuManager3.add(new Separator());
        menuManager3.add(this.queryAction);
        menuManager4.add(this.aboutAction);
        return menuManager;
    }

    protected MenuManager createContextMenuManager() {
        MenuManager menuManager = new MenuManager();
        menuManager.add(this.addAction);
        menuManager.add(this.editAction);
        menuManager.add(this.removeAction);
        return menuManager;
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout());
        this.tabFolder = new CTabFolder(composite2, 3072);
        this.tabFolder.setSelectionBackground(this.tabFolder.getBackground());
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NetworkConsoleWindow.this.setActionsEnabled();
            }
        });
        this.tabUsersView = new NetworkUsersView(this, this.createContextMenuManager().createContextMenu((Control)composite2));
        this.tabHostsView = new NetworkHostsView(this, this.createContextMenuManager().createContextMenu((Control)composite2));
        this.tabTrafficView = new NetworkTrafficView(this);
        this.tabFolder.setFocus();
        return composite2;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NetworkConsoleWindow.translate("ui.caption"));
        shell.setImage(ImageDescriptor.createFromFile(this.getClass(), "images/console.gif").createImage());
    }

    public static void main(String[] stringArray) throws IOException {
        Shell shell = new Shell();
        properties = new Properties();
        properties.load(new FileInputStream("networkconsole.properties"));
        ConnectionDialog connectionDialog = new ConnectionDialog(shell);
        if (connectionDialog.open() == 0) {
            NetworkConsoleWindow networkConsoleWindow = new NetworkConsoleWindow();
            networkConsoleWindow.setBlockOnOpen(true);
            networkConsoleWindow.open();
        }
        NetworkConsoleWindow.saveProperties();
        shell.getDisplay().dispose();
        shell.dispose();
    }

    public static String translate(String string) {
        return ResourceBundle.getBundle("networkconsole/ui/translation").getString(string);
    }

    public static void saveProperties() throws IOException {
        properties.store(new FileOutputStream("networkconsole.properties"), "Network Console Properties");
    }

    public void setActionsEnabled() {
        this.addAction.setEnabled(((INetworkConsoleView)this.tabFolder.getSelection()).isAddEnabled());
        this.editAction.setEnabled(((INetworkConsoleView)this.tabFolder.getSelection()).isEditEnabled());
        this.removeAction.setEnabled(((INetworkConsoleView)this.tabFolder.getSelection()).isRemoveEnabled());
        this.queryAction.setEnabled(((INetworkConsoleView)this.tabFolder.getSelection()).isQueryEnabled());
    }

    private class QueryAction
    extends Action {
        NetworkConsoleWindow window;

        public QueryAction(NetworkConsoleWindow networkConsoleWindow2) {
            this.window = networkConsoleWindow2;
            String string = NetworkConsoleWindow.translate("ui.actions.query");
            this.setText(string + "@F10");
            this.setToolTipText(string);
            this.setImageDescriptor(ImageDescriptor.createFromFile(this.getClass(), "images/query.gif"));
        }

        public void run() {
            ((INetworkConsoleView)NetworkConsoleWindow.this.tabFolder.getSelection()).query();
        }
    }

    private class EditAction
    extends Action {
        NetworkConsoleWindow window;

        public EditAction(NetworkConsoleWindow networkConsoleWindow2) {
            this.window = networkConsoleWindow2;
            String string = NetworkConsoleWindow.translate("ui.actions.edit");
            this.setText(string + "@Ctrl+E");
            this.setToolTipText(string);
            this.setImageDescriptor(ImageDescriptor.createFromFile(this.getClass(), "images/edit.gif"));
        }

        public void run() {
            ((INetworkConsoleView)NetworkConsoleWindow.this.tabFolder.getSelection()).edit();
        }
    }

    private class RemoveAction
    extends Action {
        NetworkConsoleWindow window;

        public RemoveAction(NetworkConsoleWindow networkConsoleWindow2) {
            this.window = networkConsoleWindow2;
            String string = NetworkConsoleWindow.translate("ui.actions.remove");
            this.setText(string + "@Ctrl+R");
            this.setToolTipText(string);
            this.setImageDescriptor(ImageDescriptor.createFromFile(this.getClass(), "images/remove.gif"));
        }

        public void run() {
            MessageDialog messageDialog = new MessageDialog(NetworkConsoleWindow.this.getShell(), NetworkConsoleWindow.this.getShell().getText(), null, NetworkConsoleWindow.translate("ui.actions.remove.warning"), 4, new String[]{NetworkConsoleWindow.translate("ui.dialog.yes"), NetworkConsoleWindow.translate("ui.dialog.no")}, 1);
            messageDialog.open();
            if (messageDialog.getReturnCode() == 0) {
                ((INetworkConsoleView)NetworkConsoleWindow.this.tabFolder.getSelection()).remove();
            }
        }
    }

    private class AddAction
    extends Action {
        NetworkConsoleWindow window;

        public AddAction(NetworkConsoleWindow networkConsoleWindow2) {
            this.window = networkConsoleWindow2;
            String string = NetworkConsoleWindow.translate("ui.actions.add");
            this.setText(string + "@Ctrl+A");
            this.setToolTipText(string);
            this.setImageDescriptor(ImageDescriptor.createFromFile(this.getClass(), "images/add.gif"));
        }

        public void run() {
            ((INetworkConsoleView)NetworkConsoleWindow.this.tabFolder.getSelection()).add();
        }
    }

    private class AboutAction
    extends Action {
        NetworkConsoleWindow window;

        public AboutAction(NetworkConsoleWindow networkConsoleWindow2) {
            this.window = networkConsoleWindow2;
            String string = NetworkConsoleWindow.translate("ui.actions.about");
            this.setText(string + "@Ctrl+?");
            this.setToolTipText(string);
            this.setImageDescriptor(ImageDescriptor.createFromFile(this.getClass(), "images/info.gif"));
        }

        public void run() {
            MessageDialog.openInformation(NetworkConsoleWindow.this.getShell(), NetworkConsoleWindow.this.getShell().getText(), NetworkConsoleWindow.translate("ui.actions.about.text"));
        }
    }

    private class ExportAction
    extends Action {
        NetworkConsoleWindow window;

        public ExportAction(NetworkConsoleWindow networkConsoleWindow2) {
            this.window = networkConsoleWindow2;
            String string = NetworkConsoleWindow.translate("ui.actions.export");
            this.setText(string + "@F6");
            this.setToolTipText(string);
            this.setImageDescriptor(ImageDescriptor.createFromFile(this.getClass(), "images/export.gif"));
        }

        public void run() {
            SAXSource sAXSource = ((INetworkConsoleView)NetworkConsoleWindow.this.tabFolder.getSelection()).export();
            ExportDialog exportDialog = new ExportDialog(NetworkConsoleWindow.this.getShell(), sAXSource, properties);
            exportDialog.open();
            try {
                NetworkConsoleWindow.saveProperties();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private class RefreshAction
    extends Action {
        NetworkConsoleWindow window;

        public RefreshAction(NetworkConsoleWindow networkConsoleWindow2) {
            this.window = networkConsoleWindow2;
            String string = NetworkConsoleWindow.translate("ui.actions.refresh");
            this.setText(string + "@F5");
            this.setToolTipText(string);
            this.setImageDescriptor(ImageDescriptor.createFromFile(this.getClass(), "images/refresh.gif"));
        }

        public void run() {
            ((INetworkConsoleView)NetworkConsoleWindow.this.tabFolder.getSelection()).refresh();
        }
    }

    private class ExitAction
    extends Action {
        NetworkConsoleWindow window;

        public ExitAction(NetworkConsoleWindow networkConsoleWindow2) {
            this.window = networkConsoleWindow2;
            String string = NetworkConsoleWindow.translate("ui.actions.exit");
            this.setText(string + "@Alt+X");
            this.setToolTipText(string);
            this.setImageDescriptor(ImageDescriptor.createFromFile(this.getClass(), "images/close.gif"));
        }

        public void run() {
            System.exit(0);
        }
    }
}

