/*
 * Decompiled with CFR 0.152.
 */
package networkconsole.ui;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import networkconsole.datamodel.EntryListException;
import networkconsole.datamodel.JdbcEntryList;
import networkconsole.datamodel.LdapHostEntryList;
import networkconsole.datamodel.LdapUserEntryList;
import networkconsole.ui.NetworkConsoleWindow;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConnectionDialog
extends TitleAreaDialog {
    private Text ldapConnectionText;
    private Text ldapUserText;
    private Text ldapPasswordText;
    private Text jdbcConnectionText;
    private Text jdbcUserText;
    private Text jdbcPasswordText;
    private Button savePasswordsButton;
    private Text connectionMessagesText;
    private CTabFolder tabFolder;

    public ConnectionDialog(Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new FormLayout());
        composite3.setLayoutData((Object)new GridData(1808));
        Composite composite4 = new Composite(composite3, 0);
        composite4.setLayout((Layout)new GridLayout());
        FormData formData = new FormData();
        formData.bottom = new FormAttachment(100, 0);
        formData.right = new FormAttachment(100, -4);
        formData.top = new FormAttachment(0, 4);
        formData.left = new FormAttachment(0, 4);
        composite4.setLayoutData((Object)formData);
        this.tabFolder = new CTabFolder(composite4, 2048);
        this.tabFolder.setSelectionBackground(this.tabFolder.getBackground());
        this.tabFolder.setLayoutData((Object)new GridData(256));
        this.tabFolder.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ConnectionDialog.this.ldapConnectionText.setFocus();
            }
        });
        CTabItem cTabItem = new CTabItem(this.tabFolder, 0);
        cTabItem.setText("LDAP");
        cTabItem.setImage(ImageDescriptor.createFromFile(this.getClass(), "images/tree.gif").createImage());
        Composite composite5 = new Composite((Composite)this.tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 7;
        gridLayout.marginHeight = 7;
        gridLayout.horizontalSpacing = 15;
        composite5.setLayout((Layout)gridLayout);
        composite5.setFocus();
        cTabItem.setControl((Control)composite5);
        Label label = new Label(composite5, 0);
        label.setText(NetworkConsoleWindow.translate("ui.dialog.connection.label.connection"));
        this.ldapConnectionText = new Text(composite5, 2048);
        this.ldapConnectionText.setLayoutData((Object)new GridData(768));
        this.ldapConnectionText.setText(NetworkConsoleWindow.properties.getProperty("connection.ldap.url"));
        label = new Label(composite5, 0);
        label.setText(NetworkConsoleWindow.translate("ui.dialog.connection.label.user"));
        this.ldapUserText = new Text(composite5, 2048);
        this.ldapUserText.setLayoutData((Object)new GridData(768));
        this.ldapUserText.setText(NetworkConsoleWindow.properties.getProperty("connection.ldap.user"));
        label = new Label(composite5, 0);
        label.setText(NetworkConsoleWindow.translate("ui.dialog.connection.label.password"));
        this.ldapPasswordText = new Text(composite5, 2048);
        this.ldapPasswordText.setLayoutData((Object)new GridData(768));
        this.ldapPasswordText.setText(NetworkConsoleWindow.properties.getProperty("connection.ldap.password"));
        this.ldapPasswordText.setEchoChar('*');
        cTabItem = new CTabItem(this.tabFolder, 0);
        cTabItem.setText("JDBC");
        cTabItem.setImage(ImageDescriptor.createFromFile(this.getClass(), "images/table.gif").createImage());
        composite5 = new Composite((Composite)this.tabFolder, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 7;
        gridLayout.marginHeight = 7;
        gridLayout.horizontalSpacing = 15;
        composite5.setLayout((Layout)gridLayout);
        cTabItem.setControl((Control)composite5);
        label = new Label(composite5, 0);
        label.setText(NetworkConsoleWindow.translate("ui.dialog.connection.label.connection"));
        this.jdbcConnectionText = new Text(composite5, 2048);
        this.jdbcConnectionText.setLayoutData((Object)new GridData(768));
        this.jdbcConnectionText.setText(NetworkConsoleWindow.properties.getProperty("connection.jdbc.url"));
        label = new Label(composite5, 0);
        label.setText(NetworkConsoleWindow.translate("ui.dialog.connection.label.user"));
        this.jdbcUserText = new Text(composite5, 2048);
        this.jdbcUserText.setLayoutData((Object)new GridData(768));
        this.jdbcUserText.setText(NetworkConsoleWindow.properties.getProperty("connection.jdbc.user"));
        label = new Label(composite5, 0);
        label.setText(NetworkConsoleWindow.translate("ui.dialog.connection.label.password"));
        this.jdbcPasswordText = new Text(composite5, 2048);
        this.jdbcPasswordText.setLayoutData((Object)new GridData(768));
        this.jdbcPasswordText.setText(NetworkConsoleWindow.properties.getProperty("connection.jdbc.password"));
        this.jdbcPasswordText.setEchoChar('*');
        this.savePasswordsButton = new Button(composite4, 32);
        this.savePasswordsButton.setText(NetworkConsoleWindow.translate("ui.dialog.connection.label.save_passwords"));
        this.savePasswordsButton.setSelection(NetworkConsoleWindow.properties.getProperty("connection.save_passwords").equals("true"));
        cTabItem = new Group(composite4, 0);
        cTabItem.setText(NetworkConsoleWindow.translate("ui.dialog.connection.label.connection_messages"));
        cTabItem.setLayoutData((Object)new GridData(1808));
        cTabItem.setLayout((Layout)new GridLayout());
        this.connectionMessagesText = new Text((Composite)cTabItem, 2882);
        composite5 = new GridData(1808);
        composite5.heightHint = 40;
        this.connectionMessagesText.setLayoutData((Object)composite5);
        this.connectionMessagesText.setEditable(false);
        this.setTitle(NetworkConsoleWindow.translate("ui.dialog.connection.title"));
        this.setMessage(NetworkConsoleWindow.translate("ui.dialog.connection.message"));
        this.tabFolder.setFocus();
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, NetworkConsoleWindow.translate("ui.dialog.ok"), true);
        this.createButton(composite, 1, NetworkConsoleWindow.translate("ui.dialog.cancel"), false);
    }

    protected void okPressed() {
        try {
            this.connect();
            this.saveConnectionSettings();
            super.okPressed();
        }
        catch (Exception exception) {
            this.connectionMessagesText.append("[" + exception.getClass().getName() + "] " + exception.getLocalizedMessage());
            exception.printStackTrace();
        }
    }

    private void saveConnectionSettings() throws IOException {
        NetworkConsoleWindow.properties.setProperty("connection.ldap.url", this.ldapConnectionText.getText());
        NetworkConsoleWindow.properties.setProperty("connection.ldap.user", this.ldapUserText.getText());
        if (this.savePasswordsButton.getSelection()) {
            NetworkConsoleWindow.properties.setProperty("connection.ldap.password", this.ldapPasswordText.getText());
        } else {
            NetworkConsoleWindow.properties.setProperty("connection.ldap.password", "");
        }
        NetworkConsoleWindow.properties.setProperty("connection.jdbc.url", this.jdbcConnectionText.getText());
        NetworkConsoleWindow.properties.setProperty("connection.jdbc.user", this.jdbcUserText.getText());
        if (this.savePasswordsButton.getSelection()) {
            NetworkConsoleWindow.properties.setProperty("connection.jdbc.password", this.jdbcPasswordText.getText());
        } else {
            NetworkConsoleWindow.properties.setProperty("connection.jdbc.password", "");
        }
        if (this.savePasswordsButton.getSelection()) {
            NetworkConsoleWindow.properties.setProperty("connection.save_passwords", "true");
        } else {
            NetworkConsoleWindow.properties.setProperty("connection.save_passwords", "false");
        }
        NetworkConsoleWindow.saveProperties();
        this.connectionMessagesText.append("Connection settings saved" + Text.DELIMITER);
    }

    private void connect() throws EntryListException, ClassNotFoundException, SQLException {
        this.connectionMessagesText.setText("");
        this.connectionMessagesText.append("LDAP connection ..." + Text.DELIMITER);
        NetworkConsoleWindow.hosts = new LdapHostEntryList(this.ldapConnectionText.getText(), NetworkConsoleWindow.properties.getProperty("connection.ldap.context.hosts"), this.ldapUserText.getText(), this.ldapPasswordText.getText());
        NetworkConsoleWindow.users = new LdapUserEntryList(this.ldapConnectionText.getText(), NetworkConsoleWindow.properties.getProperty("connection.ldap.context.users"), this.ldapUserText.getText(), this.ldapPasswordText.getText());
        this.connectionMessagesText.append("LDAP connected" + Text.DELIMITER);
        this.connectionMessagesText.append("JDBC connection ..." + Text.DELIMITER);
        Class.forName("org.firebirdsql.jdbc.FBDriver");
        Connection connection = DriverManager.getConnection(this.jdbcConnectionText.getText(), this.jdbcUserText.getText(), this.jdbcPasswordText.getText());
        boolean bl = NetworkConsoleWindow.properties.getProperty("ui.view.traffic.translate").equals("true");
        NetworkConsoleWindow.queryList = new JdbcEntryList(connection, "", bl);
        if (bl) {
            NetworkConsoleWindow.proceduresList = new JdbcEntryList(connection, "", true);
            NetworkConsoleWindow.proceduresList.setSqlProceduresList();
        }
        this.connectionMessagesText.append("JDBC connected" + Text.DELIMITER);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NetworkConsoleWindow.translate("ui.dialog.connection.caption"));
    }
}

