/*
 * Decompiled with CFR 0.152.
 */
package networkconsole.tests;

import java.io.FileInputStream;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import networkconsole.datamodel.Entry;
import networkconsole.datamodel.EntryList;
import networkconsole.datamodel.EntryListException;
import networkconsole.datamodel.IEntryListAdapter;
import networkconsole.datamodel.JdbcEntryList;
import networkconsole.datamodel.LdapEntryList;
import networkconsole.datamodel.LdapEntryReflector;
import networkconsole.datamodel.LdapHostEntry;
import networkconsole.datamodel.LdapHostEntryList;
import networkconsole.datamodel.LdapUserEntry;
import networkconsole.datamodel.LdapUserEntryList;
import networkconsole.datamodel.sax.JdbcEntryListInputSource;
import networkconsole.datamodel.sax.JdbcEntryListXMLReader;
import networkconsole.datamodel.sax.LdapEntryListInputSource;
import networkconsole.datamodel.sax.LdapEntryListXMLReader;

public class Testing
extends TestCase {
    Properties properties = new Properties();
    static /* synthetic */ Class class$networkconsole$tests$Testing;

    public Testing(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Class)(class$networkconsole$tests$Testing == null ? (class$networkconsole$tests$Testing = Testing.class$("networkconsole.tests.Testing")) : class$networkconsole$tests$Testing));
    }

    protected void setUp() throws Exception {
        this.properties.load(new FileInputStream("networkconsole.properties"));
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLdapUserEntryList() throws EntryListException {
        System.out.println("create EntryList: LdapUserEntryList");
        LdapUserEntryList ldapUserEntryList = new LdapUserEntryList(this.properties.getProperty("connection.ldap.url"), this.properties.getProperty("connection.ldap.context.users"), this.properties.getProperty("connection.ldap.user"), this.properties.getProperty("connection.ldap.password"));
        System.out.println("add change listener for EntryList: " + ldapUserEntryList.getClass().getName());
        ldapUserEntryList.addChangeListener(new IEntryListAdapter(){

            public void entryAdd(Entry entry) throws EntryListException {
                System.out.println("entryAdd: " + entry);
            }

            public void entryEdit(Entry entry) throws EntryListException {
                System.out.println("entryEdit: " + entry);
            }

            public void entryRemove(Entry entry) throws EntryListException {
                System.out.println("entryRemove: " + entry);
            }

            public void refresh() throws EntryListException {
                System.out.println("refresh");
            }
        });
        this.printEntryList(ldapUserEntryList);
        System.out.println("change entry for EntryList: " + ldapUserEntryList.getClass().getName());
        LdapUserEntry ldapUserEntry = (LdapUserEntry)ldapUserEntryList.getEntries().get(0);
        ldapUserEntry.setFullName("LDAP User 1");
        this.printEntryList(ldapUserEntryList);
        System.out.println("add entry for EntryList: " + ldapUserEntryList.getClass().getName());
        LdapUserEntry ldapUserEntry2 = new LdapUserEntry("ldapuser2");
        ldapUserEntry2.setUid("1002");
        ldapUserEntry2.setGid("10");
        ldapUserEntry2.setFullName("LDAP User 2");
        ldapUserEntry2.setShell("/bin/bash");
        ldapUserEntry2.setHome("/home/ldapuser2");
        ((EntryList)ldapUserEntryList).add(ldapUserEntry2);
        this.printEntryList(ldapUserEntryList);
        System.out.println("remove entry for EntryList: " + ldapUserEntryList.getClass().getName());
        LdapUserEntry ldapUserEntry3 = new LdapUserEntry("ldapuser2");
        ((EntryList)ldapUserEntryList).remove(ldapUserEntry3);
        this.printEntryList(ldapUserEntryList);
        ((EntryList)ldapUserEntryList).dispose();
    }

    public void testLdapHostEntryList() throws EntryListException {
        System.out.println("create EntryList: LdapHostEntryList");
        LdapHostEntryList ldapHostEntryList = new LdapHostEntryList(this.properties.getProperty("connection.ldap.url"), this.properties.getProperty("connection.ldap.context.hosts"), this.properties.getProperty("connection.ldap.user"), this.properties.getProperty("connection.ldap.password"));
        System.out.println("add change listener for EntryList: " + ldapHostEntryList.getClass().getName());
        ldapHostEntryList.addChangeListener(new IEntryListAdapter(){

            public void entryAdd(Entry entry) throws EntryListException {
                System.out.println("entryAdd: " + entry);
            }

            public void entryEdit(Entry entry) throws EntryListException {
                System.out.println("entryEdit: " + entry);
            }

            public void entryRemove(Entry entry) throws EntryListException {
                System.out.println("entryRemove: " + entry);
            }

            public void refresh() throws EntryListException {
                System.out.println("refresh");
            }
        });
        this.printEntryList(ldapHostEntryList);
        System.out.println("change entry for EntryList: " + ldapHostEntryList.getClass().getName());
        LdapHostEntry ldapHostEntry = (LdapHostEntry)ldapHostEntryList.getEntries().get(0);
        ldapHostEntry.setDhcpHWAddress("00:00:00:00:00:00");
        this.printEntryList(ldapHostEntryList);
        System.out.println("add entry for EntryList: " + ldapHostEntryList.getClass().getName());
        LdapHostEntry ldapHostEntry2 = new LdapHostEntry("host2");
        ldapHostEntry2.setDhcpHWAddress("00:00:00:00:00:00");
        ldapHostEntry2.setDhcpIPAddress("192.168.101.1");
        ldapHostEntry2.setAllowNat(new Boolean(true));
        ldapHostEntry2.setAllowProxy(new Boolean(true));
        ldapHostEntry2.setForceProxy(new Boolean(true));
        ((EntryList)ldapHostEntryList).add(ldapHostEntry2);
        this.printEntryList(ldapHostEntryList);
        System.out.println("remove entry for EntryList: " + ldapHostEntryList.getClass().getName());
        LdapHostEntry ldapHostEntry3 = new LdapHostEntry("host2");
        ((EntryList)ldapHostEntryList).remove(ldapHostEntry3);
        this.printEntryList(ldapHostEntryList);
        ((EntryList)ldapHostEntryList).dispose();
    }

    public void testJdbcEntryList() throws EntryListException, SQLException, ClassNotFoundException {
        System.out.println("create JDBC connection");
        Class.forName("org.firebirdsql.jdbc.FBDriver");
        Connection connection = DriverManager.getConnection(this.properties.getProperty("connection.jdbc.url"), this.properties.getProperty("connection.jdbc.user"), this.properties.getProperty("connection.jdbc.password"));
        System.out.println("create EntryList: JdbcEntryList");
        JdbcEntryList jdbcEntryList = new JdbcEntryList(connection, "", this.properties.getProperty("ui.view.traffic.translate").equals("true"));
        jdbcEntryList.setSql("select first 3 * from proxy_log");
        this.printEntryList(jdbcEntryList);
        jdbcEntryList.dispose();
    }

    public void testReflectionEntryList() throws EntryListException {
        System.out.println("create EntryList: LdapUserEntryList");
        LdapUserEntryList ldapUserEntryList = new LdapUserEntryList(this.properties.getProperty("connection.ldap.url"), this.properties.getProperty("connection.ldap.context.users"), this.properties.getProperty("connection.ldap.user"), this.properties.getProperty("connection.ldap.password"));
        this.printReflectedFields(((LdapEntryList)ldapUserEntryList).getEntryClass());
        System.out.println("create EntryList: LdapHostEntryList");
        LdapHostEntryList ldapHostEntryList = new LdapHostEntryList(this.properties.getProperty("connection.ldap.url"), this.properties.getProperty("connection.ldap.context.hosts"), this.properties.getProperty("connection.ldap.user"), this.properties.getProperty("connection.ldap.password"));
        this.printReflectedFields(((LdapEntryList)ldapHostEntryList).getEntryClass());
    }

    public void testSaxJdbcEntryList() throws EntryListException, SQLException, ClassNotFoundException, TransformerConfigurationException, TransformerException {
        System.out.println("create JDBC connection");
        Class.forName("org.firebirdsql.jdbc.FBDriver");
        Connection connection = DriverManager.getConnection(this.properties.getProperty("connection.jdbc.url"), this.properties.getProperty("connection.jdbc.user"), this.properties.getProperty("connection.jdbc.password"));
        System.out.println("create EntryList: JdbcEntryList");
        JdbcEntryList jdbcEntryList = new JdbcEntryList(connection, "", this.properties.getProperty("ui.view.traffic.translate").equals("true"));
        jdbcEntryList.setSql("select first 3 * from proxy_log");
        SAXSource sAXSource = new SAXSource(new JdbcEntryListXMLReader(), new JdbcEntryListInputSource(jdbcEntryList.getClass().getName(), jdbcEntryList));
        StringWriter stringWriter = new StringWriter();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "cp1251");
        transformer.transform(sAXSource, new StreamResult(stringWriter));
        System.out.println(stringWriter);
        jdbcEntryList.dispose();
    }

    public void testSaxLdapEntryList() throws EntryListException, ClassNotFoundException, TransformerConfigurationException, TransformerException {
        System.out.println("create EntryList: LdapHostEntryList");
        LdapHostEntryList ldapHostEntryList = new LdapHostEntryList(this.properties.getProperty("connection.ldap.url"), this.properties.getProperty("connection.ldap.context.hosts"), this.properties.getProperty("connection.ldap.user"), this.properties.getProperty("connection.ldap.password"));
        SAXSource sAXSource = new SAXSource(new LdapEntryListXMLReader(), new LdapEntryListInputSource(ldapHostEntryList.getClass().getName(), ldapHostEntryList));
        StringWriter stringWriter = new StringWriter();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "cp1251");
        transformer.transform(sAXSource, new StreamResult(stringWriter));
        System.out.println(stringWriter);
        ldapHostEntryList.dispose();
    }

    private void printEntryList(EntryList entryList) {
        System.out.println("print EntryList: " + entryList.getClass().getName());
        Iterator iterator = entryList.getEntries().iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    private void printReflectedFields(Class clazz) {
        System.out.println("print reflected fields LdapEntryList: " + clazz.getName());
        LdapEntryReflector ldapEntryReflector = new LdapEntryReflector(clazz);
        System.out.println("describe methods:");
        this.printMethods(ldapEntryReflector.getDescribeMethods().iterator());
        System.out.println("getter methods:");
        this.printMethods(ldapEntryReflector.getGetterMethods().iterator());
        System.out.println("setter methods:");
        this.printMethods(ldapEntryReflector.getSetterMethods().iterator());
    }

    private void printMethods(Iterator iterator) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null) continue;
            System.out.println("\t" + e.toString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

