/*
 * Decompiled with CFR 0.152.
 */
package networkconsole.datamodel.swt.providers;

import networkconsole.datamodel.Entry;
import networkconsole.datamodel.EntryListException;
import networkconsole.datamodel.IEntryListAdapter;
import networkconsole.datamodel.LdapEntry;
import networkconsole.datamodel.LdapEntryList;
import networkconsole.datamodel.LdapEntryReflector;
import networkconsole.swt.extensions.ITableColumnProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class LdapEntryListProvider
extends LabelProvider
implements ITableColumnProvider,
ITableLabelProvider,
IStructuredContentProvider,
IEntryListAdapter {
    private TableViewer viewer;
    private LdapEntryReflector reflector;
    private static final String CHECKED_IMAGE = "true";
    private static final String UNCHECKED_IMAGE = "false";
    private static final String ROW_IMAGE = "row";
    private static ImageRegistry imageRegistry = new ImageRegistry();
    static /* synthetic */ Class class$networkconsole$datamodel$swt$providers$LdapEntryListProvider;

    public int[] getColumnsAlign() {
        return null;
    }

    public String[] getColumns() {
        if (this.reflector != null) {
            String[] stringArray = new String[this.reflector.getDescribeMethods().size()];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = this.reflector.getDescribeMethods().get(i).toString();
                try {
                    stringArray[i] = this.reflector.invokeMethod(null, string);
                    continue;
                }
                catch (Exception exception) {
                    stringArray[i] = "Error: " + string;
                }
            }
            return stringArray;
        }
        return null;
    }

    public Image getColumnImage(Object object, int n) {
        LdapEntry ldapEntry = (LdapEntry)object;
        String string = this.reflector.getGetterMethods().get(n).toString();
        if (string.startsWith("is")) {
            try {
                return imageRegistry.get(this.reflector.invokeMethod(ldapEntry, string));
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (n == 0) {
            return imageRegistry.get(ROW_IMAGE);
        }
        return null;
    }

    public String getColumnText(Object object, int n) {
        LdapEntry ldapEntry = (LdapEntry)object;
        String string = this.reflector.getGetterMethods().get(n).toString();
        if (string.startsWith("get")) {
            try {
                return this.reflector.invokeMethod(ldapEntry, string);
            }
            catch (Exception exception) {
                return "Error: " + string;
            }
        }
        return "";
    }

    public Object[] getElements(Object object) {
        return ((LdapEntryList)object).getEntries().toArray();
    }

    public void entryAdd(Entry entry) throws EntryListException {
        if (this.viewer != null) {
            this.viewer.add(entry);
        }
    }

    public void entryEdit(Entry entry) throws EntryListException {
        if (this.viewer != null) {
            this.viewer.update(entry, null);
        }
    }

    public void entryRemove(Entry entry) throws EntryListException {
        if (this.viewer != null) {
            this.viewer.remove(entry);
        }
    }

    public void refresh() throws EntryListException {
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.viewer = (TableViewer)viewer;
        if (object2 != null) {
            ((LdapEntryList)object2).addChangeListener(this);
            this.reflector = new LdapEntryReflector(((LdapEntryList)object2).getEntryClass());
        }
        if (object != null) {
            ((LdapEntryList)object).removeChangeListener(this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = "images/";
        imageRegistry.put(CHECKED_IMAGE, ImageDescriptor.createFromFile(class$networkconsole$datamodel$swt$providers$LdapEntryListProvider == null ? (class$networkconsole$datamodel$swt$providers$LdapEntryListProvider = LdapEntryListProvider.class$("networkconsole.datamodel.swt.providers.LdapEntryListProvider")) : class$networkconsole$datamodel$swt$providers$LdapEntryListProvider, string + CHECKED_IMAGE + ".gif"));
        imageRegistry.put(UNCHECKED_IMAGE, ImageDescriptor.createFromFile(class$networkconsole$datamodel$swt$providers$LdapEntryListProvider == null ? (class$networkconsole$datamodel$swt$providers$LdapEntryListProvider = LdapEntryListProvider.class$("networkconsole.datamodel.swt.providers.LdapEntryListProvider")) : class$networkconsole$datamodel$swt$providers$LdapEntryListProvider, string + UNCHECKED_IMAGE + ".gif"));
        imageRegistry.put(ROW_IMAGE, ImageDescriptor.createFromFile(class$networkconsole$datamodel$swt$providers$LdapEntryListProvider == null ? (class$networkconsole$datamodel$swt$providers$LdapEntryListProvider = LdapEntryListProvider.class$("networkconsole.datamodel.swt.providers.LdapEntryListProvider")) : class$networkconsole$datamodel$swt$providers$LdapEntryListProvider, string + ROW_IMAGE + ".gif"));
    }
}

