/*
 * Decompiled with CFR 0.152.
 */
package networkconsole.datamodel.swt.dialogs;

import java.io.File;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import networkconsole.datamodel.swt.dialogs.FileText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ExportDialog
extends Dialog {
    private FileText fileText;
    private FileText appText;
    private Combo styleCombo;
    private Button appCheck;
    private Button styleCheck;
    private SAXSource source;
    private Properties properties;

    public ExportDialog(Shell shell, SAXSource sAXSource, Properties properties) {
        super(shell);
        this.source = sAXSource;
        this.properties = properties;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new FormLayout());
        GridData gridData = new GridData(1808);
        gridData.widthHint = 400;
        composite3.setLayoutData((Object)gridData);
        Composite composite4 = new Composite(composite3, 0);
        composite4.setLayout((Layout)new GridLayout());
        FormData formData = new FormData();
        formData.bottom = new FormAttachment(100, 5);
        formData.right = new FormAttachment(100, 5);
        formData.top = new FormAttachment(0, -5);
        formData.left = new FormAttachment(0, -5);
        composite4.setLayoutData((Object)formData);
        Group group = new Group(composite4, 0);
        group.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 7;
        gridLayout.marginHeight = 7;
        gridLayout.horizontalSpacing = 15;
        group.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)group, 0);
        label.setText(ExportDialog.translate("ui.dialog.export.label.file"));
        this.fileText = new FileText((Composite)group, 0);
        this.fileText.setLayoutData(new GridData(768));
        this.fileText.setText(this.makeFileName());
        this.styleCheck = new Button((Composite)group, 32);
        this.styleCheck.setText(ExportDialog.translate("ui.dialog.export.label.style"));
        this.styleCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExportDialog.this.setStyleCheck(ExportDialog.this.styleCheck.getSelection());
            }
        });
        this.styleCombo = new Combo((Composite)group, 0);
        this.styleCombo.setLayoutData((Object)new GridData(256));
        this.styleCombo.setEnabled(this.styleCheck.getSelection());
        this.styleCombo.setItems(this.makeXsltFileNames());
        if (this.styleCombo.getItemCount() > 0) {
            this.styleCombo.setText(this.styleCombo.getItem(0));
        }
        boolean bl = this.properties.getProperty("export.apply.xslt").equals("true");
        this.styleCheck.setSelection(bl);
        this.setStyleCheck(bl);
        this.appCheck = new Button((Composite)group, 32);
        this.appCheck.setText(ExportDialog.translate("ui.dialog.export.label.application"));
        this.appCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExportDialog.this.setAppCheck(ExportDialog.this.appCheck.getSelection());
            }
        });
        this.appText = new FileText((Composite)group, 0);
        this.appText.setLayoutData(new GridData(768));
        this.appText.setEnabled(this.appCheck.getSelection());
        this.appText.setText(this.properties.getProperty("export.path.application"));
        bl = this.properties.getProperty("export.apply.application").equals("true");
        this.appCheck.setSelection(bl);
        this.setAppCheck(bl);
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, ExportDialog.translate("ui.dialog.ok"), true);
        this.createButton(composite, 1, ExportDialog.translate("ui.dialog.cancel"), false);
    }

    protected void okPressed() {
        try {
            this.exportData();
            this.openData();
            this.saveSettings();
        }
        catch (Exception exception) {
            MessageDialog.openError(this.getShell(), this.getShell().getText(), "[" + exception.getClass().getName() + "] " + exception.getLocalizedMessage());
            exception.printStackTrace();
        }
        super.okPressed();
    }

    private void exportData() throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = this.styleCheck.getSelection() ? transformerFactory.newTransformer(new StreamSource(this.properties.getProperty("export.path.xslt") + File.separator + this.styleCombo.getText())) : transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", this.properties.getProperty("export.encoding"));
        transformer.transform(this.source, new StreamResult(this.fileText.getText()));
    }

    private void openData() throws Exception {
        if (this.appCheck.getSelection()) {
            Runtime.getRuntime().exec(this.appText.getText() + " " + this.fileText.getText());
        }
    }

    private void saveSettings() throws Exception {
        this.properties.setProperty("export.path.application", this.appText.getText());
        this.properties.setProperty("export.apply.application", this.appCheck.getSelection() ? "true" : "false");
        this.properties.setProperty("export.apply.xslt", this.styleCheck.getSelection() ? "true" : "false");
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ExportDialog.translate("ui.dialog.export.caption"));
    }

    private String makeFileName() {
        return this.properties.getProperty("export.path.file") + File.separator + "filename.xml";
    }

    private String[] makeXsltFileNames() {
        return new File(this.properties.getProperty("export.path.xslt")).list();
    }

    private void setStyleCheck(boolean bl) {
        this.styleCombo.setEnabled(bl);
        if (bl) {
            this.fileText.setText(this.fileText.getText().replaceAll("xml", "html"));
        } else {
            this.fileText.setText(this.fileText.getText().replaceAll("html", "xml"));
        }
    }

    private void setAppCheck(boolean bl) {
        this.appText.setEnabled(bl);
    }

    public static String translate(String string) {
        return ResourceBundle.getBundle("networkconsole/datamodel/swt/dialogs/translation").getString(string);
    }
}

