/*
 * Decompiled with CFR 0.152.
 */
package networkconsole.datamodel.swt.dialogs;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.ResourceBundle;
import networkconsole.datamodel.LdapEntry;
import networkconsole.datamodel.LdapEntryList;
import networkconsole.datamodel.LdapEntryReflector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EntryDialog
extends Dialog {
    private LdapEntryList list;
    private LdapEntry entry;
    private LdapEntryReflector reflector;
    private ArrayList editControls = new ArrayList();

    public EntryDialog(Shell shell, LdapEntryList ldapEntryList, LdapEntry ldapEntry) {
        super(shell);
        this.list = ldapEntryList;
        this.entry = ldapEntry;
        this.reflector = new LdapEntryReflector(ldapEntryList.getEntryClass());
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new FormLayout());
        GridData gridData = new GridData(1808);
        gridData.widthHint = 500;
        composite3.setLayoutData((Object)gridData);
        Composite composite4 = new Composite(composite3, 0);
        composite4.setLayout((Layout)new GridLayout());
        FormData formData = new FormData();
        formData.bottom = new FormAttachment(100, 5);
        formData.right = new FormAttachment(100, 5);
        formData.top = new FormAttachment(0, -5);
        formData.left = new FormAttachment(0, -5);
        composite4.setLayoutData((Object)formData);
        Group group = new Group(composite4, 0);
        group.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 7;
        gridLayout.marginHeight = 7;
        gridLayout.horizontalSpacing = 15;
        group.setLayout((Layout)gridLayout);
        this.createEntryEditor(group);
        return composite2;
    }

    private void createEntryEditor(Group group) {
        for (int i = 0; i < this.reflector.getDescribeMethods().size(); ++i) {
            try {
                Text text;
                Label label = new Label((Composite)group, 0);
                String string = this.reflector.getDescribeMethods().get(i).toString();
                String string2 = "";
                string2 = this.reflector.invokeMethod(null, string);
                label.setText(string2);
                String string3 = this.reflector.getGetterMethods().get(i).toString();
                if (string3.startsWith("get")) {
                    text = new Text((Composite)group, 2048);
                    this.editControls.add(text);
                    text.setLayoutData((Object)new GridData(768));
                    if (this.entry == null) continue;
                    text.setText(this.reflector.invokeMethod(this.entry, string3));
                    continue;
                }
                if (string3.startsWith("is")) {
                    text = new Button((Composite)group, 32);
                    this.editControls.add(text);
                    if (this.entry == null) continue;
                    text.setSelection(this.reflector.invokeMethod(this.entry, string3) == "true");
                    continue;
                }
                text = new Composite((Composite)group, 0);
                this.editControls.add(text);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.reflector.getDescribeMethods().size() > 0 && this.entry != null) {
            ((Control)this.editControls.get(0)).setEnabled(false);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, EntryDialog.translate("ui.dialog.ok"), true);
        this.createButton(composite, 1, EntryDialog.translate("ui.dialog.cancel"), false);
    }

    protected void okPressed() {
        try {
            if (this.entry == null) {
                this.addEntry();
            } else {
                this.editEntry();
            }
            super.okPressed();
        }
        catch (Exception exception) {
            MessageDialog.openError(this.getShell(), this.getShell().getText(), "[" + exception.getClass().getName() + "] " + exception.getLocalizedMessage());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEntry() throws Exception {
        try {
            Constructor<?>[] constructorArray = this.list.getEntryClass().getDeclaredConstructors();
            String string = ((Text)this.editControls.get(0)).getText();
            this.entry = (LdapEntry)constructorArray[0].newInstance(string);
            this.fillEntryFields();
            this.list.add(this.entry);
        }
        finally {
            this.entry = null;
        }
    }

    private void fillEntryFields() throws IOException {
        for (int i = 1; i < this.editControls.size(); ++i) {
            Object e = this.reflector.getSetterMethods().get(i);
            if (e == null) continue;
            String string = e.toString();
            Object object = this.methodParam(i, string);
            this.reflector.invokeMethod(this.entry, string, object);
        }
    }

    private Object methodParam(int n, String string) throws IOException {
        if (this.editControls.get(n) instanceof Text) {
            return ((Text)this.editControls.get(n)).getText();
        }
        if (this.editControls.get(n) instanceof Button) {
            return new Boolean(((Button)this.editControls.get(n)).getSelection());
        }
        return null;
    }

    protected void editEntry() throws Exception {
        this.fillEntryFields();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(EntryDialog.translate("ui.dialog.entry.caption"));
    }

    public static String translate(String string) {
        return ResourceBundle.getBundle("networkconsole/datamodel/swt/dialogs/translation").getString(string);
    }
}

