/*
 * Decompiled with CFR 0.152.
 */
package networkconsole.datamodel;

import networkconsole.datamodel.EntryListException;
import networkconsole.datamodel.LdapEntry;

public class LdapHostEntry
extends LdapEntry {
    private String name;
    private String dhcpHWAddress;
    private String dhcpIPAddress;
    private Boolean allowNat;
    private Boolean allowProxy;
    private Boolean forceProxy;
    private String comment;

    public LdapHostEntry(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name + ":" + this.dhcpHWAddress + ":" + this.dhcpIPAddress + ":" + (this.allowNat != false ? "TRUE" : "FALSE") + ":" + (this.allowProxy != false ? "TRUE" : "FALSE") + ":" + (this.forceProxy != false ? "TRUE" : "FALSE") + ":" + this.comment;
    }

    public boolean equals(Object object) {
        if (object instanceof LdapHostEntry) {
            return ((LdapHostEntry)object).name.equals(this.name);
        }
        return false;
    }

    public Boolean isAllowNat() {
        return this.allowNat;
    }

    public Boolean isAllowProxy() {
        return this.allowProxy;
    }

    public String getDhcpHWAddress() {
        return this.dhcpHWAddress;
    }

    public String getDhcpIPAddress() {
        return this.dhcpIPAddress;
    }

    public Boolean isForceProxy() {
        return this.forceProxy;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setAllowNat(Boolean bl) throws EntryListException {
        this.allowNat = bl;
        this.change();
    }

    public void setAllowProxy(Boolean bl) throws EntryListException {
        this.allowProxy = bl;
        this.change();
    }

    public void setDhcpHWAddress(String string) throws EntryListException {
        this.dhcpHWAddress = string;
        this.change();
    }

    public void setDhcpIPAddress(String string) throws EntryListException {
        this.dhcpIPAddress = string;
        this.change();
    }

    public void setForceProxy(Boolean bl) throws EntryListException {
        this.forceProxy = bl;
        this.change();
    }

    public void setComment(String string) throws EntryListException {
        this.comment = string;
        this.change();
    }

    public static String describe00Name() {
        return LdapHostEntry.translate("host.name");
    }

    public static String describe01DhcpHWAddress() {
        return LdapHostEntry.translate("host.dhcp.hwaddress");
    }

    public static String describe02DhcpIPAddress() {
        return LdapHostEntry.translate("host.dhcp.ipaddress");
    }

    public static String describe03AllowNat() {
        return LdapHostEntry.translate("host.allow.nat");
    }

    public static String describe04AllowProxy() {
        return LdapHostEntry.translate("host.allow.proxy");
    }

    public static String describe05ForceProxy() {
        return LdapHostEntry.translate("host.force.proxy");
    }

    public static String describe06Comment() {
        return LdapHostEntry.translate("host.comment");
    }
}

