/*
 * Decompiled with CFR 0.152.
 */
package networkconsole.datamodel;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import networkconsole.datamodel.LdapEntry;

public class LdapEntryReflector {
    private Class entryClass;
    private ArrayList describeMethods = new ArrayList();
    private ArrayList getterMethods = new ArrayList();
    private ArrayList setterMethods = new ArrayList();

    public LdapEntryReflector(Class clazz) {
        this.readMethods(clazz);
    }

    private void readMethods(Class clazz) {
        this.entryClass = clazz;
        Method[] methodArray = clazz.getMethods();
        Arrays.sort(methodArray, new MethodsComparator());
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            if (!string.startsWith("describe")) continue;
            this.describeMethods.add(string);
            String string2 = string.substring(10);
            if (Arrays.binarySearch(methodArray, "is" + string2, new Methods2StringComparator()) >= 0) {
                this.getterMethods.add("is" + string2);
            } else if (Arrays.binarySearch(methodArray, "get" + string2, new Methods2StringComparator()) >= 0) {
                this.getterMethods.add("get" + string2);
            } else {
                this.getterMethods.add(null);
            }
            if (Arrays.binarySearch(methodArray, "set" + string2, new Methods2StringComparator()) >= 0) {
                this.setterMethods.add("set" + string2);
                continue;
            }
            this.setterMethods.add(null);
        }
    }

    public String invokeMethod(LdapEntry ldapEntry, String string) throws IOException {
        try {
            if (ldapEntry != null) {
                Object object = this.entryClass.getMethod(string, null).invoke((Object)ldapEntry, null);
                if (object != null) {
                    return object.toString();
                }
                return "null";
            }
            String string2 = this.entryClass.getMethod(string, null).invoke((Object)this.entryClass, null).toString();
            if (string2 != null) {
                return string2.toString();
            }
            return "null";
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("Invoking method " + string + " failed");
        }
    }

    public void invokeMethod(LdapEntry ldapEntry, String string, Object object) throws IOException {
        try {
            if (ldapEntry != null) {
                this.entryClass.getMethod(string, object.getClass()).invoke((Object)ldapEntry, object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("Invoking method " + string + " failed");
        }
    }

    public ArrayList getDescribeMethods() {
        return this.describeMethods;
    }

    public ArrayList getGetterMethods() {
        return this.getterMethods;
    }

    public ArrayList getSetterMethods() {
        return this.setterMethods;
    }

    public String asString() {
        String string = "";
        string = string + "describe methods:\n";
        Iterator iterator = this.describeMethods.iterator();
        while (iterator.hasNext()) {
            string = string + "\t" + iterator.next().toString() + "\n";
        }
        return string;
    }

    private class Methods2StringComparator
    implements Comparator {
        private Methods2StringComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Method)object).getName().compareTo(object2.toString());
        }
    }

    private class MethodsComparator
    implements Comparator {
        private MethodsComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Method)object).getName().compareTo(((Method)object2).getName());
        }
    }
}

