/*
 * Decompiled with CFR 0.152.
 */
package networkconsole.datamodel;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import networkconsole.datamodel.Entry;
import networkconsole.datamodel.EntryList;
import networkconsole.datamodel.EntryListException;
import networkconsole.datamodel.LdapEntry;

public abstract class LdapEntryList
extends EntryList {
    protected InitialDirContext ctx;

    public LdapEntryList(String string, String string2, String string3, String string4) throws EntryListException {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            this.setFactories(hashtable);
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            hashtable.put("java.naming.provider.url", string + "/" + string2);
            hashtable.put("java.naming.security.principal", string3);
            hashtable.put("java.naming.security.credentials", string4);
            this.ctx = new InitialDirContext(hashtable);
            this.load();
        }
        catch (NamingException namingException) {
            throw new EntryListException(namingException.toString(true));
        }
    }

    public void dispose() throws EntryListException {
        try {
            this.entries.clear();
            this.ctx.close();
        }
        catch (NamingException namingException) {
            throw new EntryListException(namingException.toString(true));
        }
    }

    public void load() throws EntryListException {
        try {
            NamingEnumeration<Binding> namingEnumeration = this.ctx.listBindings("");
            while (namingEnumeration.hasMore()) {
                Binding binding = namingEnumeration.next();
                LdapEntry ldapEntry = this.getEntry(binding.getObject());
                this.innerAdd(ldapEntry);
            }
        }
        catch (NamingException namingException) {
            throw new EntryListException(namingException.toString(true));
        }
    }

    public void entryChanged(Entry entry) throws EntryListException {
        try {
            this.ctx.rebind("cn=" + this.getEntryCn(entry), (Object)entry);
            this.edit(entry);
        }
        catch (NamingException namingException) {
            throw new EntryListException(namingException.toString(true));
        }
    }

    public void add(Entry entry) throws EntryListException {
        try {
            this.ctx.bind("cn=" + this.getEntryCn(entry), (Object)entry);
            super.add(entry);
        }
        catch (NamingException namingException) {
            throw new EntryListException(namingException.toString(true));
        }
    }

    public void remove(Entry entry) throws EntryListException {
        try {
            this.ctx.unbind("cn=" + this.getEntryCn(entry));
            super.remove(entry);
        }
        catch (NamingException namingException) {
            throw new EntryListException(namingException.toString(true));
        }
    }

    protected abstract void setFactories(Hashtable var1);

    protected abstract LdapEntry getEntry(Object var1);

    public abstract Class getEntryClass();

    protected abstract String getEntryCn(Object var1);
}

