/*
 * Decompiled with CFR 0.152.
 */
package networkconsole.datamodel;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.ResourceBundle;
import networkconsole.datamodel.Entry;
import networkconsole.datamodel.EntryList;
import networkconsole.datamodel.EntryListException;
import networkconsole.datamodel.JdbcEntry;

public class JdbcEntryList
extends EntryList {
    private Connection connection;
    private String sql;
    private ArrayList fieldNames;
    private ArrayList fieldTypes;
    private String translation;
    private boolean translate;

    public JdbcEntryList(Connection connection, String string, boolean bl) throws EntryListException {
        this.connection = connection;
        this.sql = string;
        this.translate = bl;
        this.setTranslation();
        this.load();
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String string) throws EntryListException {
        this.sql = string;
        this.refresh();
    }

    public void setSqlProceduresList() throws EntryListException {
        this.sql = "select system_name, translated_name from translation where language='" + this.translation + "' and object_type='PROCEDURE'";
        this.refresh();
    }

    private void setTranslation() {
        if (this.translate) {
            this.translation = ResourceBundle.getBundle("networkconsole/datamodel/translation").getString("jdbc.translation");
        }
    }

    private String getTranslatedField(String string) throws EntryListException {
        String string2 = string;
        if (this.translate) {
            try {
                Statement statement = this.connection.createStatement();
                ResultSet resultSet = statement.executeQuery("select translated_name from translation where language='" + this.translation + "' and " + "object_type='COLUMN' and " + "system_name='" + string + "'");
                if (resultSet.next()) {
                    string2 = resultSet.getString(1);
                }
                resultSet.close();
                statement.close();
            }
            catch (SQLException sQLException) {
                throw new EntryListException(sQLException.getLocalizedMessage());
            }
        }
        return string2;
    }

    protected void innerClear() {
        if (this.fieldNames != null) {
            this.fieldNames.clear();
        }
        this.entries.clear();
    }

    private String getDelimitedNumeric(String string) {
        int n;
        if (string == "" || string == null) {
            return "";
        }
        String string2 = "";
        for (n = string.length(); n > 3; n -= 3) {
            string2 = string.substring(n - 3, n) + " " + string2;
        }
        string2 = string.substring(0, n) + " " + string2;
        return string2;
    }

    protected void load() throws EntryListException {
        if (!this.sql.equals("")) {
            try {
                Statement statement = this.connection.createStatement();
                ResultSet resultSet = statement.executeQuery(this.sql);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                this.fieldNames = new ArrayList(resultSetMetaData.getColumnCount());
                this.fieldTypes = new ArrayList(resultSetMetaData.getColumnCount());
                for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                    this.fieldNames.add(this.getTranslatedField(resultSetMetaData.getColumnName(i + 1)));
                    this.fieldTypes.add(resultSetMetaData.getColumnTypeName(i + 1));
                }
                while (resultSet.next()) {
                    JdbcEntry jdbcEntry = new JdbcEntry(resultSetMetaData.getColumnCount());
                    for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                        String string = resultSetMetaData.getColumnTypeName(i + 1) == "NUMERIC" ? this.getDelimitedNumeric(resultSet.getString(i + 1)) : resultSet.getString(i + 1);
                        jdbcEntry.addField(string);
                    }
                    this.innerAdd(jdbcEntry);
                }
                resultSet.close();
                statement.close();
            }
            catch (SQLException sQLException) {
                throw new EntryListException(sQLException.getLocalizedMessage());
            }
        }
    }

    public void dispose() throws EntryListException {
    }

    public void entryChanged(Entry entry) throws EntryListException {
    }

    public ArrayList getFieldNames() {
        return this.fieldNames;
    }

    public ArrayList getFieldTypes() {
        return this.fieldTypes;
    }

    public void add(Entry entry) throws EntryListException {
        throw new EntryListException("Restricted");
    }

    protected void edit(Entry entry) throws EntryListException {
        throw new EntryListException("Restricted");
    }

    public void remove(Entry entry) throws EntryListException {
        throw new EntryListException("Restricted");
    }
}

