/*
 * Decompiled with CFR 0.152.
 */
package networkconsole.datamodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import networkconsole.datamodel.Entry;
import networkconsole.datamodel.EntryListException;
import networkconsole.datamodel.IEntryAdapter;
import networkconsole.datamodel.IEntryListAdapter;

public abstract class EntryList
implements IEntryAdapter {
    protected Set changeListeners = new HashSet();
    protected ArrayList entries = new ArrayList();

    public ArrayList getEntries() {
        return this.entries;
    }

    public abstract void dispose() throws EntryListException;

    protected abstract void load() throws EntryListException;

    private void clear() {
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            entry.removeChangeListener();
        }
        this.innerClear();
    }

    protected void innerClear() {
        this.entries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws EntryListException {
        Iterator iterator;
        try {
            this.clear();
            this.load();
            Object var2_1 = null;
            iterator = this.changeListeners.iterator();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Iterator iterator2 = this.changeListeners.iterator();
            while (iterator2.hasNext()) {
                ((IEntryListAdapter)iterator2.next()).refresh();
            }
            throw throwable;
        }
        while (iterator.hasNext()) {
            ((IEntryListAdapter)iterator.next()).refresh();
        }
    }

    public void add(Entry entry) throws EntryListException {
        this.innerAdd(entry);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IEntryListAdapter)iterator.next()).entryAdd(entry);
        }
    }

    protected void innerAdd(Entry entry) {
        if (entry != null) {
            this.entries.add(entry);
            entry.addChangeListener(this);
        }
    }

    public void remove(Entry entry) throws EntryListException {
        this.innerRemove(entry);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IEntryListAdapter)iterator.next()).entryRemove(entry);
        }
    }

    protected void innerRemove(Entry entry) {
        if (entry != null) {
            this.entries.remove(entry);
            entry.removeChangeListener();
        }
    }

    protected void edit(Entry entry) throws EntryListException {
        if (entry != null) {
            Iterator iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                ((IEntryListAdapter)iterator.next()).entryEdit(entry);
            }
        }
    }

    public void addChangeListener(IEntryListAdapter iEntryListAdapter) {
        this.changeListeners.add(iEntryListAdapter);
    }

    public void removeChangeListener(IEntryListAdapter iEntryListAdapter) {
        this.changeListeners.remove(iEntryListAdapter);
    }
}

