<?xml version="1.0" encoding="windows-1251"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <xsl:output method="html" indent="yes"/>
  
  <xsl:template match="/">
    <html>
      <head>
        <title><xsl:value-of select="table/@name"/></title>
      </head>
      <body>
        <h1><xsl:value-of select="table/@name"/></h1>
        <xsl:apply-templates select="table"/>
      </body>
    </html>
  </xsl:template>
  
  <xsl:template match="table">
    <table border="1" cellspacing="0" cellpadding="3">
      <tr>
        <xsl:apply-templates select="columns/column"/>
      </tr>
      <xsl:apply-templates select="rows//row"/>
    </table>
  </xsl:template>
  
  <xsl:template match="column">
    <td style="background-color: rgb(204, 204, 204);">
      <xsl:value-of select="."/>
    </td>
  </xsl:template>
  
  <xsl:template match="row">
    <tr>
      <xsl:apply-templates select="field"/>
    </tr>
  </xsl:template>
  
  <xsl:template match="field">
    <td>
      <xsl:value-of select="."/>
    </td>
  </xsl:template>
  
</xsl:stylesheet>