/*
 * Created on 05.07.2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */
package networkconsole.ui;

import java.text.SimpleDateFormat;
import java.util.Calendar;

import networkconsole.datamodel.EntryListException;
import networkconsole.datamodel.JdbcEntry;
import networkconsole.datamodel.swt.providers.JdbcEntryListProvider;
import networkconsole.swt.extensions.ExtendedTableViewer;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * @author Eugene Prokopiev <john@rmts.donpac.ru>
 * 
 */
public class TrafficDialog extends Dialog {

	private ExtendedTableViewer viewer;
	private Text textBegin;
	private Text textEnd;	
	private Text queryText;
	
	public TrafficDialog(Shell parent, Text queryText) {
		super(parent);
		this.queryText = queryText;
	}
	
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setLayout(new FormLayout());
		GridData gridData = new GridData(GridData.FILL_BOTH);
		gridData.widthHint = 400;
		container.setLayoutData(gridData);
		{
			final Composite composite = new Composite(container, SWT.NONE);
			composite.setLayout(new GridLayout());
			final FormData formData = new FormData();
			formData.bottom = new FormAttachment(100, 5);
			formData.right = new FormAttachment(100, 5);
			formData.top = new FormAttachment(0, -5);
			formData.left = new FormAttachment(0, -5);
			composite.setLayoutData(formData);
			{
				setupReports(composite);				
				setupPeriod(composite);
			}
		}
		
		return area;
	}
	
	private void setupPeriod(final Composite composite) {
		
		final Group groupPeriod = new Group(composite, SWT.NONE);
		groupPeriod.setLayoutData(new GridData(GridData.FILL_BOTH));
		final GridLayout layoutPeriod = new GridLayout();
		layoutPeriod.numColumns = 2;
		layoutPeriod.marginWidth = 7;
		layoutPeriod.marginHeight = 7;
		layoutPeriod.horizontalSpacing = 15;
		groupPeriod.setLayout(layoutPeriod);
		groupPeriod.setText(NetworkConsoleWindow.translate("ui.dialog.traffic.period"));
		
		new Label(groupPeriod, SWT.NONE).setText(NetworkConsoleWindow.translate("ui.dialog.traffic.period.begin"));
						
		SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy"); 
		
		Calendar begin = Calendar.getInstance();
		begin.add(Calendar.DAY_OF_YEAR, -1);
		begin.add(Calendar.MONTH, -1);
		textBegin = new Text(groupPeriod, SWT.BORDER);
		textBegin.setText(format.format(begin.getTime()));				
		
		new Label(groupPeriod, SWT.NONE).setText(NetworkConsoleWindow.translate("ui.dialog.traffic.period.end"));
		
		Calendar end = Calendar.getInstance();
		end.add(Calendar.DAY_OF_YEAR, -1);				
		textEnd = new Text(groupPeriod, SWT.BORDER);
		textEnd.setText(format.format(end.getTime()));
	}

	private void setupReports(final Composite composite) {
		
		final Group groupReports = new Group(composite, SWT.NONE);
		groupReports.setLayoutData(new GridData(GridData.FILL_BOTH));
		final GridLayout layoutReports = new GridLayout();
		groupReports.setLayout(layoutReports);
		groupReports.setText(NetworkConsoleWindow.translate("ui.dialog.traffic.reports"));
		
		viewer = new ExtendedTableViewer(groupReports, SWT.BORDER | SWT.FULL_SELECTION);
		final GridData layoutDataTable = new GridData(GridData.FILL_BOTH);
		layoutDataTable.heightHint = 100;				
		viewer.getTable().setLayoutData(layoutDataTable);				
		setupReportsTable(viewer);
	}

	private void setupReportsTable(ExtendedTableViewer viewer) {
		
		JdbcEntryListProvider provider = new JdbcEntryListProvider();
		
		viewer.setContentProvider(provider);
		viewer.setColumnProvider(provider); 
		viewer.setLabelProvider(provider);
		
		viewer.setInput(NetworkConsoleWindow.proceduresList);
		
		viewer.addSelectionChangedListener(new ISelectionChangedListener(){
			public void selectionChanged(SelectionChangedEvent event) {
				getButton(IDialogConstants.OK_ID).setEnabled(
					!event.getSelection().isEmpty());
			}
		});	
		
		if (NetworkConsoleWindow.properties.getProperty("ui.view.traffic.translate").equals("true")) {
			try {
				NetworkConsoleWindow.proceduresList.refresh();
			} catch (EntryListException e) {
				MessageDialog.openError(getShell(), getShell().getText(), 
				    "["+e.getClass().getName()+"] "+e.getLocalizedMessage());
				e.printStackTrace();
			}
		}
	}

	protected void createButtonsForButtonBar(Composite parent) {
		
		createButton(
			parent,
			IDialogConstants.OK_ID,
			NetworkConsoleWindow.translate("ui.dialog.ok"),
			true).setEnabled(false);
			
		createButton(
			parent,
			IDialogConstants.CANCEL_ID,
			NetworkConsoleWindow.translate("ui.dialog.cancel"),
			false);
	}
	
	protected void okPressed() {
		try {
			JdbcEntry entry = (JdbcEntry)((IStructuredSelection)viewer.getSelection()).getFirstElement();
			queryText.setText("-- "+entry.getField(1)+Text.DELIMITER+
				"select * from "+entry.getField(0).toLowerCase()+
				"('"+textBegin.getText()+"','"+textEnd.getText()+"')");
			super.okPressed();
		} catch (Exception e) {
			MessageDialog.openError(getShell(), getShell().getText(), 
				"["+e.getClass().getName()+"] "+e.getLocalizedMessage());
			e.printStackTrace();
		}						
	}

	protected void configureShell(Shell shell) {		
		super.configureShell(shell);
		shell.setText(NetworkConsoleWindow.translate("ui.dialog.traffic.caption"));
	}

}
