/*
 * Created on 24.06.2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 */
package networkconsole.ui;

import javax.xml.transform.sax.SAXSource;

import networkconsole.datamodel.EntryListException;
import networkconsole.datamodel.LdapUserEntry;
import networkconsole.datamodel.sax.LdapEntryListInputSource;
import networkconsole.datamodel.sax.LdapEntryListXMLReader;
import networkconsole.datamodel.swt.dialogs.EntryDialog;
import networkconsole.datamodel.swt.providers.LdapEntryListProvider;
import networkconsole.swt.extensions.ExtendedTableViewer;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Menu;

/**
 * @author Eugene Prokopiev <eugene_prokopiev@mail.ru>
 * 
 */
public class NetworkUsersView extends CTabItem implements INetworkConsoleView {

	private NetworkConsoleWindow window;
	private ExtendedTableViewer viewer;
	
	private void setActionsEnabled() {
		window.setActionsEnabled();
	}
	
	public NetworkUsersView(NetworkConsoleWindow window, Menu contextMenu) {
		
		super(window.tabFolder, SWT.NONE);		
		this.window = window;
		
		setImage(ImageDescriptor.createFromFile(getClass(), "images/users.gif").createImage());
		setText(NetworkConsoleWindow.translate("ui.view.users.caption"));
		
		viewer = new ExtendedTableViewer(window.tabFolder, SWT.BORDER | SWT.FULL_SELECTION);
		viewer.addSelectionChangedListener(new ISelectionChangedListener(){
			public void selectionChanged(SelectionChangedEvent event) {
				setActionsEnabled();
			}
		});
		
		viewer.getTable().setHeaderVisible (true);
		viewer.getTable().setLinesVisible(true);
		if (contextMenu != null)
			viewer.getTable().setMenu(contextMenu);
		
		LdapEntryListProvider provider = new LdapEntryListProvider();
		
		viewer.setContentProvider(provider);
		viewer.setColumnProvider(provider); 
		viewer.setLabelProvider(provider);
		
		viewer.setSorter(new ViewerSorter());
		
		viewer.setInput(NetworkConsoleWindow.users);
		
		setControl(viewer.getControl());	
	}
	
	public SAXSource export() {
		return new SAXSource(
			new LdapEntryListXMLReader(), 
			new LdapEntryListInputSource(
				NetworkConsoleWindow.translate("ui.view.users.caption"), 
				NetworkConsoleWindow.users));
	}

	public void refresh() {
		try {
			NetworkConsoleWindow.users.refresh();
		} catch (EntryListException e) {
			e.printStackTrace();
		}
	}
	
	public void add() {
		EntryDialog dialog = new EntryDialog(window.getShell(), NetworkConsoleWindow.users, null);
		dialog.open();
	}
	
	public void edit() {
		LdapUserEntry entry = (LdapUserEntry)((IStructuredSelection)viewer.getSelection()).getFirstElement();
		EntryDialog dialog = new EntryDialog(window.getShell(), NetworkConsoleWindow.users, entry);
		dialog.open();
	}
		
	public void query() {
	}
	
	public void remove() {
		try {
			LdapUserEntry entry = (LdapUserEntry)((IStructuredSelection)viewer.getSelection()).getFirstElement();
			NetworkConsoleWindow.users.remove(entry);
		} catch (EntryListException e) {			
			MessageDialog.openError(window.getShell(), window.getShell().getText(),"Remove error: "+e);		
		}
	}
	
	public boolean isAddEnabled() {
		return true;
	}

	public boolean isEditEnabled() {
		return !((IStructuredSelection)viewer.getSelection()).isEmpty();
	}
	
	public boolean isQueryEnabled() {
		return false;
	}
	
	public boolean isRemoveEnabled() {
		return !((IStructuredSelection)viewer.getSelection()).isEmpty();
	}
	
}
