/*
 * Created on 03.06.2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */
package networkconsole.ui;

import javax.xml.transform.sax.SAXSource;

import networkconsole.datamodel.EntryListException;
import networkconsole.datamodel.sax.JdbcEntryListInputSource;
import networkconsole.datamodel.sax.JdbcEntryListXMLReader;
import networkconsole.datamodel.swt.providers.JdbcEntryListProvider;
import networkconsole.swt.extensions.ExtendedTableViewer;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

/**
 * @author Eugene Prokopiev <eugene_prokopiev@mail.ru>
 * 
 */
public class NetworkTrafficView extends CTabItem implements INetworkConsoleView {

	private NetworkConsoleWindow window;
	
	private Text queryText;
	private Text messagesText;
	
	public NetworkTrafficView(NetworkConsoleWindow window) {
		
		super(window.tabFolder, SWT.NONE);		
		this.window = window;
		
		setImage(ImageDescriptor.createFromFile(getClass(), "images/traffic.gif").createImage());
		setText(NetworkConsoleWindow.translate("ui.view.traffic.caption"));
		
		Composite container = new Composite(window.tabFolder, SWT.NONE);
		container.setLayout(new FillLayout());	
		
		final SashForm sform = new SashForm(container, SWT.VERTICAL);		
		queryText = new Text(sform, SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL | SWT.MULTI | SWT.WRAP);		
		//queryText.setText("select first 3 log_date, client_address from proxy_log");
		queryText.setFont(new Font(container.getDisplay(), 
			NetworkConsoleWindow.properties.getProperty("ui.view.traffic.editor.font.name"), 
			new Integer(NetworkConsoleWindow.properties.getProperty("ui.view.traffic.editor.font.size")).intValue(), 
			SWT.NORMAL));
		ExtendedTableViewer viewer = new ExtendedTableViewer(sform, SWT.BORDER | SWT.FULL_SELECTION);	
		messagesText = new Text(sform, SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL | SWT.MULTI | SWT.READ_ONLY | SWT.WRAP);
		messagesText.setEditable(false);
		sform.setWeights(new int [] {1, 4, 1});
		
		setControl(container);
		
		JdbcEntryListProvider provider = new JdbcEntryListProvider();
		
		viewer.setContentProvider(provider);
		viewer.setColumnProvider(provider); 
		viewer.setLabelProvider(provider);
		
		viewer.setInput(NetworkConsoleWindow.queryList);
	}
	
	public SAXSource export() {
		
		String header;
		String query = queryText.getText();
		if (query.startsWith("-- "))
			header = query.substring(3, query.indexOf(Text.DELIMITER));
		else
			header = NetworkConsoleWindow.translate("ui.view.traffic.caption");
		
		return new SAXSource(
			new JdbcEntryListXMLReader(), 
			new JdbcEntryListInputSource(header, NetworkConsoleWindow.queryList));
	}
	
	public void refresh() {
		try {
			NetworkConsoleWindow.queryList.setSql(queryText.getText());
			messagesText.setText(NetworkConsoleWindow.translate("ui.view.traffic.message.success"));
		} catch (EntryListException e) {
			messagesText.setText("["+e.getClass().getName()+"] "+e.getLocalizedMessage());
			e.printStackTrace();
		}
	}
	
	public void add() {
	}
	
	public void edit() {
	}
		
	public void query() {
		TrafficDialog dialog = new TrafficDialog(window.getShell(),queryText);
		dialog.open();
	}
	
	public void remove() {
	}
	
	public boolean isAddEnabled() {
		return false;
	}

	public boolean isEditEnabled() {
		return false;
	}
	
	public boolean isQueryEnabled() {
		return true;
	}
	
	public boolean isRemoveEnabled() {
		return false;
	}
			
}
