/*
 * Created on 24.06.2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 */
package networkconsole.swt.extensions;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/**
 * @author Eugene Prokopiev <eugene_prokopiev@mail.ru>
 * 
 */

public class ExtendedTableViewer extends TableViewer {
	
	private ITableColumnProvider provider;
	
	public ExtendedTableViewer(Composite arg0) {
		super(arg0);
	}

	public ExtendedTableViewer(Composite arg0, int arg1) {
		super(arg0, arg1);
	}

	public ExtendedTableViewer(Table arg0) {
		super(arg0);
	}
	
	public void setColumnProvider(ITableColumnProvider provider) {
		this.provider = provider;
	}
	
	protected void internalRefresh(Object element) {
		if (provider != null)
			columnsFill();
		super.internalRefresh(element);
		pack();
	}
	
	protected void inputChanged(Object newInput, Object oldInput) {
		if (newInput != null && provider != null)
			provider.inputChanged(this, oldInput, newInput);
		super.inputChanged(newInput, oldInput);
		pack();
	}
	
	protected void columnsFill(){
		String columns[] = provider.getColumns();
		int alignments[] = provider.getColumnsAlign();
		if (columns != null) {
			int count = getTable().getColumnCount();
			for (int i=0;i<count;i++)
				getTable().getColumn(0).dispose();
			for (int i=0;i<columns.length;i++) {
				final TableColumn tableColumn = new TableColumn(getTable(), SWT.NONE);
				tableColumn.setText(columns[i]);
				//tableColumn.setAlignment(SWT.RIGHT);
				if (alignments != null)
					tableColumn.setAlignment(alignments[i]);
			}
			setColumnProperties(columns);
		}
	}

	public void pack() {	
		for (int i=0;i<getTable().getColumnCount();i++)
			getTable().getColumn(i).pack();
	}

}
