/*
 * Created on 01.07.2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */
package networkconsole.datamodel.swt.providers;

import networkconsole.datamodel.Entry;
import networkconsole.datamodel.EntryListException;
import networkconsole.datamodel.IEntryListAdapter;
import networkconsole.datamodel.LdapEntry;
import networkconsole.datamodel.LdapEntryList;
import networkconsole.datamodel.LdapEntryReflector;
import networkconsole.swt.extensions.ITableColumnProvider;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

/**
 * @author Eugene Prokopiev <eugene_prokopiev@mail.ru>
 * 
 */
public class LdapEntryListProvider extends LabelProvider
	implements ITableColumnProvider, ITableLabelProvider, IStructuredContentProvider, IEntryListAdapter {

	private TableViewer viewer;
	private LdapEntryReflector reflector;
	
	private static final String CHECKED_IMAGE 		= "true";
	private static final String UNCHECKED_IMAGE  	= "false";
	private static final String ROW_IMAGE  			= "row";
	
	private static ImageRegistry imageRegistry = new ImageRegistry();
	
	static {
		String iconPath = "images/"; 
		imageRegistry.put(CHECKED_IMAGE, ImageDescriptor.createFromFile(
			LdapEntryListProvider.class, 
			iconPath + CHECKED_IMAGE + ".gif"
			)
		);
		imageRegistry.put(UNCHECKED_IMAGE, ImageDescriptor.createFromFile(
			LdapEntryListProvider.class, 
			iconPath + UNCHECKED_IMAGE + ".gif"
			)
		);	
		imageRegistry.put(ROW_IMAGE, ImageDescriptor.createFromFile(
			LdapEntryListProvider.class, 
			iconPath + ROW_IMAGE + ".gif"
			)
		);
	}	

	/* (non-Javadoc)
	 * @see networkconsole.swt.extensions.ITableColumnProvider#getColumnsAlign(java.lang.Object)
	 */
	public int[] getColumnsAlign() {
		return null;
	}
	
	/* (non-Javadoc)
	 * @see networkconsole.swt.extensions.ITableColumnProvider#getColumns(java.lang.Object)
	 */
	public String[] getColumns() {
		if (reflector != null) {
			String result[] = new String[reflector.getDescribeMethods().size()];
			for(int i=0; i<result.length; i++) {
				String methodName = reflector.getDescribeMethods().get(i).toString();
				try {
					result[i] = reflector.invokeMethod(null, methodName);
				} catch (Exception e) {
					result[i] = "Error: "+methodName;
				}
			}				
			return result;
		} else {
			return null;
		}		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
	 */
	public Image getColumnImage(Object element, int columnIndex) {
		LdapEntry entry = (LdapEntry)element;		
		String methodName = reflector.getGetterMethods().get(columnIndex).toString();
		if (methodName.startsWith("is")) {		
			try {
				return imageRegistry.get(reflector.invokeMethod(entry, methodName));
			} catch (Exception e) {
				return null;
			}
		} else if (columnIndex == 0) { 
			return imageRegistry.get("row");
		} else {
			return null;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
	 */
	public String getColumnText(Object element, int columnIndex) {
		LdapEntry entry = (LdapEntry)element;
		String methodName = reflector.getGetterMethods().get(columnIndex).toString();
		if (methodName.startsWith("get")) {		
			try {
				return reflector.invokeMethod(entry, methodName);
			} catch (Exception e) {
				return "Error: "+methodName;
			}
		}
		else
			return "";		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object input) {
		//System.out.println("getElements ldap");
		return ((LdapEntryList)input).getEntries().toArray();
	}

	/* (non-Javadoc)
	 * @see networkconsole.datamodel.IEntryListAdapter#entryAdd(networkconsole.datamodel.Entry)
	 */
	public void entryAdd(Entry entry) throws EntryListException {
		if (viewer != null)
			viewer.add(entry);		
	}

	/* (non-Javadoc)
	 * @see networkconsole.datamodel.IEntryListAdapter#entryEdit(networkconsole.datamodel.Entry)
	 */
	public void entryEdit(Entry entry) throws EntryListException {
		if (viewer != null)
			viewer.update(entry, null);		
	}

	/* (non-Javadoc)
	 * @see networkconsole.datamodel.IEntryListAdapter#entryRemove(networkconsole.datamodel.Entry)
	 */
	public void entryRemove(Entry entry) throws EntryListException {
		if (viewer != null)
			viewer.remove(entry);		
	}

	/* (non-Javadoc)
	 * @see networkconsole.datamodel.IEntryListAdapter#refresh()
	 */
	public void refresh() throws EntryListException {
		if (viewer != null)
			viewer.refresh();		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		this.viewer = (TableViewer)viewer;	
		if (newInput != null) {
			((LdapEntryList)newInput).addChangeListener(this);
			this.reflector = new LdapEntryReflector(((LdapEntryList)newInput).getEntryClass());
		}
		if (oldInput != null) {
			((LdapEntryList)oldInput).removeChangeListener(this);
		}
	}

}
