/*
 * Created on 01.07.2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */
package networkconsole.datamodel.swt.providers;

import java.util.ArrayList;

import networkconsole.datamodel.Entry;
import networkconsole.datamodel.EntryListException;
import networkconsole.datamodel.IEntryListAdapter;
import networkconsole.datamodel.JdbcEntry;
import networkconsole.datamodel.JdbcEntryList;
import networkconsole.swt.extensions.ITableColumnProvider;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;

/**
 * @author Eugene Prokopiev <eugene_prokopiev@mail.ru>
 * 
 */
public class JdbcEntryListProvider extends LabelProvider
	implements ITableColumnProvider, ITableLabelProvider, IStructuredContentProvider, IEntryListAdapter {

	private Viewer viewer;
	private JdbcEntryList list;
	
	private static final String ROW_IMAGE = "row";
	
	private static ImageRegistry imageRegistry = new ImageRegistry();
	
	static {
		String iconPath = "images/"; 
		imageRegistry.put(ROW_IMAGE, ImageDescriptor.createFromFile(
			LdapEntryListProvider.class, 
			iconPath + ROW_IMAGE + ".gif"
			)
		);
	}	

	/* (non-Javadoc)
	 * @see networkconsole.swt.extensions.ITableColumnProvider#getColumnsAlign(java.lang.Object)
	 */
	public int[] getColumnsAlign() {
		if (list != null) {
			if (list.getFieldNames() != null) {
				int result[] = new int[list.getFieldNames().size()];
				for(int i=0; i<result.length; i++) {
					result[i] = 
						(list.getFieldTypes().get(i).toString().equals("NUMERIC"))?
							(SWT.RIGHT):(SWT.NONE);
				}				
				return result;
			} else {
				return null;
			}	
		} else {
			return null;
		}	
	}
	
	/* (non-Javadoc)
	 * @see networkconsole.swt.extensions.ITableColumnProvider#getColumns(java.lang.Object)
	 */
	public String[] getColumns() {
		if (list != null) {
			if (list.getFieldNames() != null) {
				String result[] = new String[list.getFieldNames().size()];
				for(int i=0; i<result.length; i++) {
					result[i] = list.getFieldNames().get(i).toString();
				}				
				return result;
			} else {
				return null;
			}	
		} else {
			return null;
		}		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
	 */
	public Image getColumnImage(Object element, int columnIndex) {
		if (columnIndex == 0) { 
			return imageRegistry.get("row");
		} else {
			return null;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
	 */
	public String getColumnText(Object element, int columnIndex) {
		JdbcEntry entry = (JdbcEntry)element;
		return entry.getField(columnIndex);		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object input) {
		ArrayList elements = ((JdbcEntryList)input).getEntries();
		if (elements.size() > 0) {
			((TableViewer)viewer).getTable().setHeaderVisible (true);
			((TableViewer)viewer).getTable().setLinesVisible (true);
		}
		else {
			((TableViewer)viewer).getTable().setHeaderVisible (false);
			((TableViewer)viewer).getTable().setLinesVisible (false);
		}			
		return elements.toArray();
	}

	/* (non-Javadoc)
	 * @see networkconsole.datamodel.IEntryListAdapter#entryAdd(networkconsole.datamodel.Entry)
	 */
	public void entryAdd(Entry entry) throws EntryListException {

	}

	/* (non-Javadoc)
	 * @see networkconsole.datamodel.IEntryListAdapter#entryEdit(networkconsole.datamodel.Entry)
	 */
	public void entryEdit(Entry entry) throws EntryListException {
		
	}

	/* (non-Javadoc)
	 * @see networkconsole.datamodel.IEntryListAdapter#entryRemove(networkconsole.datamodel.Entry)
	 */
	public void entryRemove(Entry entry) throws EntryListException {
		
	}

	/* (non-Javadoc)
	 * @see networkconsole.datamodel.IEntryListAdapter#refresh()
	 */
	public void refresh() throws EntryListException {
		if (viewer != null)
			viewer.refresh();		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		this.viewer = viewer;	
		if (newInput != null) {
			this.list = (JdbcEntryList)newInput;
			((JdbcEntryList)newInput).addChangeListener(this);
		}
		if (oldInput != null) {
			((JdbcEntryList)oldInput).removeChangeListener(this);
		}
	}

}
