/*
 * Created on 17.06.2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */
package networkconsole.datamodel.swt.dialogs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Text;

/**
 * @author Eugene Prokopiev <john@rmts.donpac.ru>
 * 
 */
public class FileText extends Composite {

	private Text text;
	private Button button;
	
	public FileText(Composite parent, int style) {
		super(parent, style);
		final GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.horizontalSpacing = 0;
		gridLayout.marginHeight = 0;
		gridLayout.marginWidth = 0;
		gridLayout.verticalSpacing = 0;
		gridLayout.numColumns = 2;
		setLayout(gridLayout);
		{
			text = new Text(this, SWT.BORDER);
			text.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		}
		{
			button = new Button(this, SWT.NONE);
			button.setImage(ImageDescriptor.createFromFile(getClass(), "images/open.gif").createImage());
			button.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {	
					FileDialog fileDialog = new FileDialog(getShell(), SWT.OPEN); 
					fileDialog.setFileName(text.getText());
					text.setText(fileDialog.open());			
				}
			});
			button.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		}
	}
	
	protected void checkSubclass() {
	}

	public void setEnabled(boolean enabled) {
		super.setEnabled(enabled);
		text.setEnabled(enabled);
	}

	public String getText() {
		return text.getText();
	}

	public void setText(String txt) {
		text.setText(txt);
	}

}
