/*
 * Created on 24.06.2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 */
package networkconsole.datamodel.sax;

import java.io.IOException;
import java.util.Iterator;

import networkconsole.datamodel.LdapEntry;
import networkconsole.datamodel.LdapEntryList;
import networkconsole.datamodel.LdapEntryReflector;

import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

/**
 * @author Eugene Prokopiev <eugene_prokopiev@mail.ru>
 * 
 */
public class LdapEntryListXMLReader extends XMLFilterImpl {
	
	public void parse(InputSource input) throws SAXException, IOException {
		
		if (!(input instanceof LdapEntryListInputSource))
			super.parse(input);
		
		LdapEntryList list = ((LdapEntryListInputSource)input).getList();
		String name = ((LdapEntryListInputSource)input).getName();
		LdapEntryReflector reflector = new LdapEntryReflector(list.getEntryClass());
		
		AttributesImpl emptyAttrs = new AttributesImpl();
		AttributesImpl nameAttrs = new AttributesImpl();
		nameAttrs.addAttribute("", "name", "name", "", name);
			
		ContentHandler handler = getContentHandler();
		handler.startDocument();
		handler.startElement("", "table", "table", nameAttrs);
		
		Iterator columnsIterator = reflector.getDescribeMethods().iterator();
		handler.startElement("", "columns", "columns", emptyAttrs);		
		while (columnsIterator.hasNext()) {	
			String methodName = columnsIterator.next().toString();
			String columnName = reflector.invokeMethod(null, methodName);
			handler.startElement("", "column", "column", emptyAttrs);
			handler.characters(columnName.toCharArray(), 0, columnName.length());
			handler.endElement("", "column", "column");
		}	
		handler.endElement("", "columns", "columns");
		
		Iterator rows = list.getEntries().iterator();
		handler.startElement("", "rows", "rows", emptyAttrs);
		while(rows.hasNext()){
			handler.startElement("", "row", "row", emptyAttrs);
			LdapEntry entry = (LdapEntry)rows.next();
			Iterator fieldsIterator = reflector.getGetterMethods().iterator();
			while (fieldsIterator.hasNext()) {	
				String methodName = fieldsIterator.next().toString();
				String fieldValue = reflector.invokeMethod(entry, methodName);
				handler.startElement("", "field", "field", emptyAttrs);
				handler.characters(fieldValue.toCharArray(), 0, fieldValue.length());
				handler.endElement("", "field", "field");
			}	
			handler.endElement("", "row", "row");		
		}
		handler.endElement("", "rows", "rows");
				
		handler.endElement("", "table", "table");
		handler.endDocument();
	}
}
