/*
 * Created on 24.06.2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 */
package networkconsole.datamodel.persistance;

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.spi.DirStateFactory;

import networkconsole.datamodel.LdapUserEntry;

/**
 * @author Eugene Prokopiev <eugene_prokopiev@mail.ru>
 * 
 */
public class LdapUserStateFactory implements DirStateFactory {
	
	public Result getStateToBind(
		Object obj,
		Name name,
		Context nameCtx,
		Hashtable environment,
		Attributes inAttrs)
		throws NamingException {
			
		if (obj instanceof LdapUserEntry) {

			Attributes outAttrs;
			if (inAttrs == null)
				outAttrs = new BasicAttributes(true);
			else
				outAttrs = (Attributes)inAttrs.clone();
			
			if (outAttrs.get("objectClass") == null) {
				BasicAttribute oc = new BasicAttribute("objectClass");
				oc.add("posixAccount");
				outAttrs.put(oc);
			}
	
			LdapUserEntry user = (LdapUserEntry)obj;
			
			outAttrs.put("uid", user.getName());
			outAttrs.put("cn", user.getFullName());
			outAttrs.put("uidNumber", user.getUid());
			outAttrs.put("gidNumber", user.getGid());
			outAttrs.put("homeDirectory", user.getHome());
			outAttrs.put("loginShell", user.getShell());
			
			return new DirStateFactory.Result(null, outAttrs);
		}
		return null;
	}

	public Object getStateToBind(
		Object obj,
		Name name,
		Context nameCtx,
		Hashtable environment)
		throws NamingException {
		return null;
	}

}
