/*
 * Created on 24.06.2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 */
package networkconsole.datamodel.persistance;

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.spi.DirObjectFactory;

import networkconsole.datamodel.LdapUserEntry;

/**
 * @author Eugene Prokopiev <eugene_prokopiev@mail.ru>
 * 
 */
public class LdapUserObjectFactory implements DirObjectFactory{
	
	public Object getObjectInstance(
		Object obj,
		Name name,
		Context nameCtx,
		Hashtable environment,
		Attributes attrs)
		throws Exception {
			
		Attribute oc = (attrs != null ? attrs.get("objectClass") : null);
		if (oc != null && oc.contains("posixAccount")) {

			LdapUserEntry user = new LdapUserEntry((String)attrs.get("uid").get());
			user.setFullName((String)attrs.get("cn").get());
			user.setUid((String)attrs.get("uidNumber").get());
			user.setGid((String)attrs.get("gidNumber").get());
			user.setHome((String)attrs.get("homeDirectory").get());
			user.setShell((String)attrs.get("loginShell").get());
				
			return user;
		}
		return null;
	}

	public Object getObjectInstance(
		Object obj,
		Name name,
		Context ctx,
		Hashtable env)
		throws Exception {
		
		return null;
	}
}
