/*
 * Created on 24.06.2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 */
package networkconsole.datamodel;

/**
 * @author Eugene Prokopiev <eugene_prokopiev@mail.ru>
 * 
 */
public class LdapUserEntry extends LdapEntry {
	
	private String name;
	private String fullName;
	private String uid;
	private String gid;
	private String home;
	private String shell;
	
	public LdapUserEntry(String name) {
		this.name = name;
	}
	
	public boolean equals(Object object) {
		if (object instanceof LdapUserEntry)
			return ((LdapUserEntry)object).name.equals(name);
		else
			return false;
	}	

	public String getName() {
		return name;
	}
	
	public String getFullName() {
		return fullName;
	}

	public String getGid() {
		return gid;
	}

	public String getHome() {
		return home;
	}

	public String getShell() {
		return shell;
	}

	public String getUid() {
		return uid;
	}

	public void setFullName(String string) throws EntryListException {
		this.fullName = string;
		change();
	}

	public void setGid(String string) throws EntryListException {
		this.gid = string;
		change();
	}

	public void setHome(String string) throws EntryListException {
		this.home = string;
		change();
	}

	public void setShell(String string) throws EntryListException {
		this.shell = string;
		change();
	}

	public void setUid(String string) throws EntryListException {
		this.uid = string;
		change();
	}
	
	public String toString() {
		return name+":"+uid+":"+gid+":"+fullName+":"+home+":"+shell;
	}
	
	public static String describe00Name() {
		return translate("user.name");
	}
	
	public static String describe01FullName() {
		return translate("user.fullname");
	}
	
	public static String describe02Uid() {
		return translate("user.uid");
	}

	public static String describe03Gid() {
		return translate("user.gid");
	}

	public static String describe04Home() {
		return translate("user.home");
	}

	public static String describe05Shell() {
		return translate("user.shell");
	}	

}
