/*
 * Created on 24.06.2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 */
package networkconsole.datamodel;

import java.util.Hashtable;

import javax.naming.Context;

/**
 * @author Eugene Prokopiev <eugene_prokopiev@mail.ru>
 * 
 */
public class LdapHostEntryList extends LdapEntryList {
	
	public LdapHostEntryList(
		String url,
		String context,
		String user,
		String password)
		throws EntryListException {			
		super(url, context, user, password);
	}
	
	protected void setFactories(Hashtable env) {		
		env.put(Context.OBJECT_FACTORIES, "networkconsole.datamodel.persistance.LdapHostObjectFactory");
		env.put(Context.STATE_FACTORIES, "networkconsole.datamodel.persistance.LdapHostStateFactory");		
	}
	
	protected LdapEntry getEntry(Object entry) {
		if (entry instanceof LdapHostEntry)
			return (LdapHostEntry)entry;
		else
			return null;
	}
	
	public Class getEntryClass() {
		return LdapHostEntry.class;
	}
	
	protected String getEntryCn(Object entry) {
		return ((LdapHostEntry)entry).getName();
	}
}
