/*
 * Created on 24.06.2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 */
package networkconsole.datamodel;

/**
 * @author Eugene Prokopiev <eugene_prokopiev@mail.ru>
 * 
 */
public class LdapHostEntry extends LdapEntry {
	
	private String name;
	private String dhcpHWAddress;
	private String dhcpIPAddress;
	private Boolean allowNat;
	private Boolean allowProxy;
	private Boolean forceProxy;	
	private String comment;

	public LdapHostEntry(String name) {
			this.name = name;
	}
	
	public String toString() {
		return name+":"+dhcpHWAddress+":"+dhcpIPAddress+ 
			":"+((allowNat.booleanValue())?("TRUE"):("FALSE"))+
			":"+((allowProxy.booleanValue())?("TRUE"):("FALSE"))+
			":"+((forceProxy.booleanValue())?("TRUE"):("FALSE"))+
			":"+comment;
	}
	
	public boolean equals(Object object) {
		if (object instanceof LdapHostEntry)
			return ((LdapHostEntry)object).name.equals(name);
		else
			return false;
	}
	
	public Boolean isAllowNat() {
		return allowNat;
	}

	public Boolean isAllowProxy() {
		return allowProxy;
	}

	public String getDhcpHWAddress() {
		return dhcpHWAddress;
	}

	public String getDhcpIPAddress() {
		return dhcpIPAddress;
	}

	public Boolean isForceProxy() {
		return forceProxy;
	}

	public String getName() {
		return name;
	}
	
	public String getComment() {
		return comment;
	}

	public void setAllowNat(Boolean b) throws EntryListException {
		allowNat = b;
		change();
	}

	public void setAllowProxy(Boolean b) throws EntryListException {
		allowProxy = b;
		change();
	}

	public void setDhcpHWAddress(String string) throws EntryListException {
		dhcpHWAddress = string;
		change();
	}

	public void setDhcpIPAddress(String string) throws EntryListException {
		dhcpIPAddress = string;
		change();
	}

	public void setForceProxy(Boolean b) throws EntryListException {
		forceProxy = b;
		change();
	}
	
	public void setComment(String string) throws EntryListException {
		comment = string;
		change();
	}
	
	public static String describe00Name() {
		return translate("host.name");
	}
	
	public static String describe01DhcpHWAddress() {
		return translate("host.dhcp.hwaddress");
	}

	public static String describe02DhcpIPAddress() {
		return translate("host.dhcp.ipaddress");
	}
	
	public static String describe03AllowNat() {
		return translate("host.allow.nat");
	}

	public static String describe04AllowProxy() {
		return translate("host.allow.proxy");
	}

	public static String describe05ForceProxy() {
		return translate("host.force.proxy");
	}
	
	public static String describe06Comment() {
		return translate("host.comment");
	}	

}
