/*
 * Created on 26.06.2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */
package networkconsole.datamodel;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.ResourceBundle;

/**
 * @author Eugene Prokopiev <eugene_prokopiev@mail.ru>
 * 
 */
public class JdbcEntryList extends EntryList {

	private Connection connection;
	private String sql;
	private ArrayList fieldNames;
	private ArrayList fieldTypes;
	private String translation;
	private boolean translate;
	
	public JdbcEntryList(Connection connection, String sql, boolean translate) throws EntryListException {		
		this.connection = connection;
		this.sql = sql;	
		this.translate = translate;
		setTranslation();
		load();
	}

	public String getSql() {
		return sql;
	}

	public void setSql(String sql) throws EntryListException {
		this.sql = sql;
		refresh();
	}
	
	public void setSqlProceduresList() throws EntryListException {
		this.sql = "select system_name, translated_name from translation " +
			"where language='"+translation+"' and object_type='PROCEDURE'";
		refresh();
	}
	
	private void setTranslation() {
		if (translate) {
			translation = 
				ResourceBundle.getBundle("networkconsole/datamodel/translation").
					getString("jdbc.translation");
		}
	}
	
	private String getTranslatedField(String field) throws EntryListException {		
		String result = field;		
		if (translate) {
			try {
				Statement stmt = connection.createStatement();
				ResultSet rset = stmt.executeQuery(
					"select translated_name from translation " +
					"where language='"+translation+"' and " +
					"object_type='COLUMN' and " +
					"system_name='"+field+"'");			
				if (rset.next()) {
					result = rset.getString(1);
				}
				rset.close();
				stmt.close();
			} catch (SQLException e) {
				throw new EntryListException(e.getLocalizedMessage());
			}	
		}
		return result;
	}
	
	protected void innerClear() {
		if (fieldNames != null)
			fieldNames.clear();
		entries.clear();
	}
	
	private String getDelimitedNumeric(String number) {			
		if (number == "" || number == null)
			return "";		
		String delimited_number = "";		
		int i;
		for (i=number.length(); i>3; i-=3) 
			delimited_number = number.substring(i-3, i)+" "+delimited_number;
		delimited_number = number.substring(0, i)+" "+delimited_number;		
		return delimited_number;
	}

	protected void load() throws EntryListException {
				
		if (!sql.equals("")) {
			
			try {
				Statement stmt = connection.createStatement();
				ResultSet rset = stmt.executeQuery(sql);
				ResultSetMetaData meta = rset.getMetaData();
				
				fieldNames = new ArrayList(meta.getColumnCount());
				fieldTypes = new ArrayList(meta.getColumnCount());
				for (int i = 0; i < meta.getColumnCount(); i++) {
					fieldNames.add(getTranslatedField(meta.getColumnName(i+1)));
					fieldTypes.add(meta.getColumnTypeName(i+1));
				}
				
				while (rset.next()) {
					JdbcEntry entry = new JdbcEntry(meta.getColumnCount());
					for (int i = 0; i < meta.getColumnCount(); i++) {
						String result;
						if (meta.getColumnTypeName(i+1) == "NUMERIC")
							result = getDelimitedNumeric(rset.getString(i+1));
						else
							result = rset.getString(i+1);
						entry.addField(result);	
					}
					innerAdd(entry);
				}
				
				rset.close();
				stmt.close();
			} catch (SQLException e) {
				throw new EntryListException(e.getLocalizedMessage());
			}
		}
	}
	
	public void dispose() throws EntryListException {
	}

	public void entryChanged(Entry entry) throws EntryListException {
	}

	public ArrayList getFieldNames() {
		return fieldNames;
	}
	
	public ArrayList getFieldTypes() {
		return fieldTypes;
	}

	public void add(Entry entry) throws EntryListException {
		throw new EntryListException("Restricted");
	}

	protected void edit(Entry entry) throws EntryListException {
		throw new EntryListException("Restricted");
	}

	public void remove(Entry entry) throws EntryListException {
		throw new EntryListException("Restricted");
	}

}
