/*
 * Created on 26.06.2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */
package networkconsole.datamodel;

import java.util.ArrayList;

/**
 * @author Eugene Prokopiev <eugene_prokopiev@mail.ru>
 * 
 */
public class JdbcEntry extends Entry {

	ArrayList fields;
	
	public JdbcEntry(int size) {
		fields = new ArrayList(size);
	}
	
	public int size() {
		return fields.size();
	}
	
	public String getField(int index) {
		Object field = fields.get(index);
		return (field == null)?("[NULL]"):(field.toString());
	}
	
	void addField(String field) {
		fields.add(field);
	}
	
	public String toString() {
		String result = "";
		for(int i = 0; i < fields.size(); i++) {
			if (i > 0)
				result += ":";
			result += fields.get(i);	
		}		
		return result;	
	}

}
