/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragUnderEffect;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

class TableDragUnderEffect
extends DragUnderEffect {
    private Table table;
    private int currentEffect = 0;
    private TableItem dropSelection;
    private PaintListener paintListener;
    private TableItem scrollItem;
    private long scrollBeginTime;
    private static final int SCROLL_HYSTERESIS = 600;

    TableDragUnderEffect(Table table) {
        this.table = table;
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (TableDragUnderEffect.this.dropSelection == null || TableDragUnderEffect.this.dropSelection.isDisposed()) {
                    return;
                }
                GC gc = e.gc;
                Color foreground = gc.getForeground();
                Display display = e.widget.getDisplay();
                gc.setForeground(display.getSystemColor(20));
                Rectangle bounds = TableDragUnderEffect.this.dropSelection.getBounds(0);
                Rectangle area = TableDragUnderEffect.this.table.getClientArea();
                gc.drawRectangle(area.x, bounds.y + 1, area.width - 1, bounds.height - 3);
                gc.setForeground(foreground);
            }
        };
    }

    void show(int effect, int x, int y) {
        TableItem item = this.findItem(x, y);
        if (item == null) {
            effect = 0;
        }
        if (this.currentEffect == 0 && effect != 0) {
            this.table.addPaintListener(this.paintListener);
        }
        this.scrollHover(effect, item, x, y);
        this.setDragUnderEffect(effect, item);
        if (this.currentEffect != 0 && effect == 0) {
            this.table.removePaintListener(this.paintListener);
        }
        this.currentEffect = effect;
    }

    private TableItem findItem(int x, int y) {
        Point coordinates = new Point(x, y);
        coordinates = this.table.toControl(coordinates);
        Rectangle area = this.table.getClientArea();
        if (!area.contains(coordinates)) {
            return null;
        }
        TableItem item = this.table.getItem(coordinates);
        if (item != null) {
            return item;
        }
        int x1 = area.x;
        while (x1 < area.x + area.width) {
            Point pt = new Point(x1, coordinates.y);
            item = this.table.getItem(pt);
            if (item != null) {
                return item;
            }
            ++x1;
        }
        return null;
    }

    private void setDragUnderEffect(int effect, TableItem item) {
        if ((effect & 1) != 0) {
            this.setDropSelection(item);
            return;
        }
        if ((this.currentEffect & 1) != 0) {
            this.setDropSelection(null);
        }
    }

    private void setDropSelection(TableItem item) {
        Rectangle bounds;
        if (item == this.dropSelection) {
            return;
        }
        Rectangle area = this.table.getClientArea();
        if (this.dropSelection != null && !this.dropSelection.isDisposed()) {
            bounds = this.dropSelection.getBounds(0);
            this.table.redraw(area.x, bounds.y, area.width, bounds.height, true);
        }
        this.dropSelection = item;
        if (this.dropSelection != null && !this.dropSelection.isDisposed()) {
            bounds = this.dropSelection.getBounds(0);
            this.table.redraw(area.x, bounds.y, area.width, bounds.height, true);
        }
    }

    private void scrollHover(int effect, TableItem item, int x, int y) {
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollItem = null;
            return;
        }
        if (this.scrollItem == item && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                this.scroll(item, x, y);
                this.scrollBeginTime = 0L;
                this.scrollItem = null;
            }
            return;
        }
        this.scrollBeginTime = System.currentTimeMillis() + 600L;
        this.scrollItem = item;
    }

    private void scroll(TableItem item, int x, int y) {
        if (item == null) {
            return;
        }
        Point coordinates = new Point(x, y);
        coordinates = this.table.toControl(coordinates);
        Rectangle area = this.table.getClientArea();
        int top = this.table.getTopIndex();
        int newTop = -1;
        int scroll_width = 2 * this.table.getItemHeight();
        if (coordinates.y < area.y + scroll_width) {
            newTop = Math.max(0, top - 1);
        } else if (coordinates.y > area.y + area.height - scroll_width) {
            newTop = Math.min(this.table.getItemCount() - 1, top + 1);
        }
        if (newTop != -1 && newTop != top) {
            this.table.setTopIndex(newTop);
        }
    }
}

