/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class ManifestTask
extends Task {
    private Manifest nestedManifest = new Manifest();
    private File manifestFile;
    private Mode mode = new Mode();
    private String encoding;

    public ManifestTask() {
        this.mode.setValue("replace");
    }

    public void addConfiguredSection(Manifest.Section section) throws ManifestException {
        this.nestedManifest.addConfiguredSection(section);
    }

    public void addConfiguredAttribute(Manifest.Attribute attribute) throws ManifestException {
        this.nestedManifest.addConfiguredAttribute(attribute);
    }

    public void setFile(File f) {
        this.manifestFile = f;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMode(Mode m) {
        this.mode = m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void execute() throws BuildException {
        block29: {
            if (this.manifestFile == null) {
                throw new BuildException("the file attribute is required");
            }
            toWrite = Manifest.getDefaultManifest();
            current = null;
            error = null;
            if (this.manifestFile.exists()) {
                fis = null;
                isr = null;
                try {
                    fis = new FileInputStream(this.manifestFile);
                    isr = this.encoding == null ? new InputStreamReader((InputStream)fis, "UTF-8") : new InputStreamReader((InputStream)fis, this.encoding);
                    current = new Manifest(isr);
                    var9_8 = null;
                    ** if (isr == null) goto lbl-1000
                }
                catch (Throwable var8_19) {
                    var9_11 = null;
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw var8_19;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        isr.close();
                    }
                    catch (IOException e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block29;
                    catch (ManifestException m) {
                        error = new BuildException("Existing manifest " + this.manifestFile + " is invalid", m, this.location);
                        var9_9 = null;
                        if (isr != null) {
                            try {
                                isr.close();
                            }
                            catch (IOException e) {}
                        }
                        break block29;
                    }
                    catch (IOException e) {
                        error = new BuildException("Failed to read " + this.manifestFile, e, this.location);
                        var9_10 = null;
                        if (isr != null) {
                            try {
                                isr.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
            }
        }
        try {
            if (this.mode.getValue().equals("update") && this.manifestFile.exists()) {
                if (current != null) {
                    toWrite.merge(current);
                } else if (error != null) {
                    throw error;
                }
            }
            toWrite.merge(this.nestedManifest);
        }
        catch (ManifestException m) {
            throw new BuildException("Manifest is invalid", m, this.location);
        }
        if (toWrite.equals(current)) {
            this.log("Manifest has not changed, do not recreate", 3);
            return;
        }
        w = null;
        try {
            try {
                fos = new FileOutputStream(this.manifestFile);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                w = new PrintWriter(osw);
                toWrite.write(w);
            }
            catch (IOException e) {
                throw new BuildException("Failed to write " + this.manifestFile, e, this.location);
            }
            var12_20 = null;
            if (w != null) {
                w.close();
            }
        }
        catch (Throwable var11_22) {
            var12_21 = null;
            if (w != null) {
                w.close();
            }
            throw var11_22;
        }
    }

    public static class Mode
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"update", "replace"};
        }
    }
}

