/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jgds;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.security.auth.Subject;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.isc_db_handle;
import org.firebirdsql.jgds.XdrInputStream;
import org.firebirdsql.jgds.XdrOutputStream;
import org.firebirdsql.jgds.isc_tr_handle_impl;

public final class isc_db_handle_impl
implements isc_db_handle {
    private int rdb_id;
    private Subject subject;
    private Collection rdb_transactions = new ArrayList();
    private List rdb_warnings = new ArrayList();
    private boolean invalid;
    Socket socket;
    public XdrOutputStream out;
    public XdrInputStream in;
    private int resp_object;
    private long resp_blob_id;
    private byte[] resp_data;
    private int dialect = 0;
    private int protocol = 0;
    private String version = null;
    private int ODSMajorVersion = 0;
    private int ODSMinorVersion = 0;

    void addTransaction(isc_tr_handle_impl tr) {
        this.checkValidity();
        this.rdb_transactions.add(tr);
    }

    public void addWarning(GDSException warning) {
        this.checkValidity();
        List list = this.rdb_warnings;
        synchronized (list) {
            this.rdb_warnings.add(warning);
        }
    }

    private void checkValidity() {
        if (this.invalid) {
            throw new IllegalStateException("This database handle is invalid and cannot be used anymore.");
        }
    }

    public void clearWarnings() {
        this.checkValidity();
        List list = this.rdb_warnings;
        synchronized (list) {
            this.rdb_warnings.clear();
        }
    }

    public int getDatabaseProductMajorVersion() {
        if (this.version.indexOf("Firebird") != -1) {
            if (this.version.indexOf("Firebird 1.0") != -1) {
                return 1;
            }
            if (this.version.indexOf("Firebird 1.5") != -1) {
                return 1;
            }
            return -1;
        }
        return -1;
    }

    public int getDatabaseProductMinorVersion() {
        if (this.version.indexOf("Firebird") != -1) {
            if (this.version.indexOf("Firebird 1.0") != -1) {
                return 0;
            }
            if (this.version.indexOf("Firebird 1.5") != -1) {
                return 5;
            }
            return -1;
        }
        return -1;
    }

    public String getDatabaseProductName() {
        if (this.version.indexOf("Firebird") != -1) {
            return "Firebird";
        }
        return "Interbase";
    }

    public String getDatabaseProductVersion() {
        return this.version;
    }

    public int getDialect() {
        return this.dialect;
    }

    public int getODSMajorVersion() {
        return this.ODSMajorVersion;
    }

    public int getODSMinorVersion() {
        return this.ODSMinorVersion;
    }

    int getOpenTransactionCount() {
        this.checkValidity();
        return this.rdb_transactions.size();
    }

    public int getProtocol() {
        return this.protocol;
    }

    public int getRdb_id() {
        this.checkValidity();
        return this.rdb_id;
    }

    public long getResp_blob_id() {
        return this.resp_blob_id;
    }

    public byte[] getResp_data() {
        return this.resp_data;
    }

    public int getResp_object() {
        return this.resp_object;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Collection getTransactions() {
        return new ArrayList(this.rdb_transactions);
    }

    public String getVersion() {
        return this.version;
    }

    public List getWarnings() {
        this.checkValidity();
        List list = this.rdb_warnings;
        synchronized (list) {
            ArrayList arrayList = new ArrayList(this.rdb_warnings);
            Object var3_3 = null;
            return arrayList;
        }
    }

    public boolean hasTransactions() {
        this.checkValidity();
        return this.rdb_transactions.isEmpty() ^ true;
    }

    void invalidate() throws IOException {
        this.in.close();
        this.out.close();
        this.socket.close();
        this.in = null;
        this.out = null;
        this.socket = null;
        this.invalid = true;
    }

    public boolean isValid() {
        return this.invalid ^ true;
    }

    void removeTransaction(isc_tr_handle_impl tr) {
        this.checkValidity();
        this.rdb_transactions.remove(tr);
    }

    public void setDialect(int value) {
        this.dialect = value;
    }

    public void setODSMajorVersion(int value) {
        this.ODSMajorVersion = value;
    }

    public void setODSMinorVersion(int value) {
        this.ODSMinorVersion = value;
    }

    public void setProtocol(int value) {
        this.protocol = value;
    }

    public void setRdb_id(int rdb_id) {
        this.checkValidity();
        this.rdb_id = rdb_id;
    }

    public void setResp_blob_id(long value) {
        this.resp_blob_id = value;
    }

    public void setResp_data(byte[] value) {
        this.resp_data = value;
    }

    public void setResp_object(int value) {
        this.resp_object = value;
    }

    void setSubject(Subject subject) {
        this.subject = subject;
    }

    public void setVersion(String value) {
        this.version = value;
    }
}

