/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jgds;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.firebirdsql.gds.Clumplet;
import org.firebirdsql.jgds.XdrInputStream;
import org.firebirdsql.jgds.XdrOutputStream;
import org.firebirdsql.jgds.Xdrable;

public class ClumpletImpl
implements Clumplet,
Xdrable,
Serializable {
    int type;
    byte[] content;
    ClumpletImpl next;

    ClumpletImpl(int type, byte[] content) {
        this.type = type;
        this.content = content;
    }

    public void append(Clumplet c) {
        ClumpletImpl ci = (ClumpletImpl)c;
        if (this.type == ci.type) {
            this.content = ci.content;
        } else if (this.next == null) {
            this.next = ci;
        } else {
            this.next.append(c);
        }
    }

    ClumpletImpl cloneClumplet() {
        ClumpletImpl newClumplet = new ClumpletImpl(this.type, this.content);
        if (this.next != null) {
            newClumplet.next = this.next.cloneClumplet();
        }
        return newClumplet;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ClumpletImpl)) {
            return false;
        }
        ClumpletImpl c = (ClumpletImpl)o;
        if (this.type != c.type || !Arrays.equals(this.content, c.content)) {
            return false;
        }
        if (this.next != null) {
            return this.next.equals(c.next);
        }
        return c.next == null;
    }

    public byte[] find(int type) {
        if (type == this.type) {
            return this.content;
        }
        if (this.next == null) {
            return null;
        }
        return this.next.find(type);
    }

    public String findString(int type) {
        if (type == this.type) {
            throw new IllegalStateException("Do not call getStringContent on a non-StringClumplet!");
        }
        if (this.next == null) {
            return null;
        }
        return this.next.findString(type);
    }

    protected ClumpletImpl getCopy() {
        return new ClumpletImpl(this.type, this.content);
    }

    public int getLength() {
        if (this.next == null) {
            return this.content.length + 2;
        }
        return this.content.length + 2 + this.next.getLength();
    }

    public int hashCode() {
        int arrayhash = this.type;
        int i = 0;
        while (i < this.content.length) {
            arrayhash ^= this.content[i] << 8 * (i % 4);
            ++i;
        }
        if (this.next != null) {
            arrayhash ^= this.next.hashCode();
        }
        return arrayhash;
    }

    public void read(XdrInputStream in, int length) {
    }

    public Clumplet remove(int type) {
        ClumpletImpl c = this;
        ClumpletImpl result = null;
        if (this.type == type) {
            c = this.next;
        }
        while (c != null) {
            if (c.type != type) {
                ClumpletImpl clone = c.getCopy();
                if (result != null) {
                    result.append(clone);
                } else {
                    result = clone;
                }
            }
            c = c.next;
        }
        return result;
    }

    public void write(XdrOutputStream out) throws IOException {
        out.write(this.type);
        out.write(this.content.length);
        out.write(this.content);
        if (this.next != null) {
            this.next.write(out);
        }
    }
}

