/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBField;
import org.firebirdsql.jdbc.FBResultSet;

class FBTimestampField
extends FBField {
    FBTimestampField(XSQLVAR field, FBResultSet rs, int numCol) throws SQLException {
        super(field, rs, numCol);
    }

    java.sql.Date getDate() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return new java.sql.Date(((Date)this.getTimestamp()).getTime());
    }

    java.sql.Date getDate(Calendar cal) throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return XSQLVAR.decodeDate(this.getDate(), cal);
    }

    Object getObject() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return XSQLVAR.decodeTimestamp(this.rs.row[this.numCol]);
    }

    String getString() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return String.valueOf(XSQLVAR.decodeTimestamp(this.rs.row[this.numCol]));
    }

    Time getTime() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return new Time(((Date)this.getTimestamp()).getTime());
    }

    Time getTime(Calendar cal) throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return XSQLVAR.decodeTime(this.getTime(), cal);
    }

    Timestamp getTimestamp() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return XSQLVAR.decodeTimestamp(this.rs.row[this.numCol]);
    }

    Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return XSQLVAR.decodeTimestamp(this.getTimestamp(), cal);
    }

    void setDate(java.sql.Date value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setTimestamp(new Timestamp(value.getTime()));
    }

    void setDate(java.sql.Date value, Calendar cal) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setDate(XSQLVAR.encodeDate(value, cal));
    }

    void setString(String value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setTimestamp(Timestamp.valueOf(value));
    }

    void setTime(Time value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setTimestamp(new Timestamp(value.getTime()));
    }

    void setTime(Time value, Calendar cal) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setTime(XSQLVAR.encodeTime(value, cal));
    }

    void setTimestamp(Timestamp value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.field.sqldata = XSQLVAR.encodeTimestamp(value);
    }

    void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setTimestamp(XSQLVAR.encodeTimestamp(value, cal));
    }
}

