/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import javax.resource.ResourceException;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.jca.FBResourceException;

public class FBSQLException
extends SQLException {
    private Exception original;
    private String message;

    public FBSQLException(IOException ioex) {
        super(ioex.getMessage());
        this.original = ioex;
        this.message = "I/O Exception. " + ioex.getMessage();
    }

    public FBSQLException(ResourceException ex) {
        super(ex.getMessage());
        FBResourceException rex;
        this.original = ex instanceof FBResourceException ? ((rex = (FBResourceException)ex).getOriginal() != null ? rex.getOriginal() : rex) : ex;
        this.message = "Resource Exception. " + ex.getMessage();
    }

    public FBSQLException(GDSException ex) {
        super(ex.getMessage());
        this.original = ex;
        this.message = "GDS Exception. " + ex.getMessage();
    }

    public int getErrorCode() {
        if (this.original instanceof GDSException) {
            return ((GDSException)this.original).getIntParam();
        }
        return 0;
    }

    public Exception getInternalException() {
        return this.original;
    }

    public String getMessage() {
        return this.message;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.original != null) {
            s.print("at ");
            this.original.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.original != null) {
            s.print("at ");
            this.original.printStackTrace(s);
        }
    }
}

