/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBField;
import org.firebirdsql.jdbc.FBResultSet;

class FBLongField
extends FBField {
    FBLongField(XSQLVAR field, FBResultSet rs, int numCol) throws SQLException {
        super(field, rs, numCol);
    }

    BigDecimal getBigDecimal() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return BigDecimal.valueOf(XSQLVAR.decodeLong(this.rs.row[this.numCol]));
    }

    boolean getBoolean() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return false;
        }
        return XSQLVAR.decodeLong(this.rs.row[this.numCol]) == 1L;
    }

    byte getByte() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Long value = new Long(XSQLVAR.decodeLong(this.rs.row[this.numCol]));
        if (value > 127L || value < -128L) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.BYTE_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        return value.byteValue();
    }

    double getDouble() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0;
        }
        return XSQLVAR.decodeLong(this.rs.row[this.numCol]);
    }

    float getFloat() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0f;
        }
        return XSQLVAR.decodeLong(this.rs.row[this.numCol]);
    }

    int getInt() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Long value = new Long(XSQLVAR.decodeLong(this.rs.row[this.numCol]));
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.INT_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        return value.intValue();
    }

    long getLong() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0L;
        }
        return XSQLVAR.decodeLong(this.rs.row[this.numCol]);
    }

    Object getObject() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return new Long(XSQLVAR.decodeLong(this.rs.row[this.numCol]));
    }

    short getShort() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Long value = new Long(XSQLVAR.decodeLong(this.rs.row[this.numCol]));
        if (value > 32767L || value < -32768L) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.BYTE_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        return value.shortValue();
    }

    String getString() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return String.valueOf(XSQLVAR.decodeLong(this.rs.row[this.numCol]));
    }

    void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        if (value.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) > 0 || value.compareTo(BigDecimal.valueOf(Long.MIN_VALUE)) < 0) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.BIGDECIMAL_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        this.setLong(value.longValue());
    }

    void setBoolean(boolean value) throws SQLException {
        this.setLong(value ? 1 : 0);
    }

    void setByte(byte value) throws SQLException {
        this.setLong(value);
    }

    void setDouble(double value) throws SQLException {
        if (value > 9.223372036854776E18 || value < -9.223372036854776E18) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.DOUBLE_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        this.setLong((long)value);
    }

    void setFloat(float value) throws SQLException {
        if (value > 9.223372E18f || value < -9.223372E18f) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.FLOAT_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        this.setLong((long)value);
    }

    void setInteger(int value) throws SQLException {
        this.setLong(value);
    }

    void setLong(long value) throws SQLException {
        this.field.sqldata = XSQLVAR.encodeLong(value);
    }

    void setShort(short value) throws SQLException {
        this.setLong(value);
    }

    void setString(String value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        try {
            this.setLong(Long.parseLong(value));
        }
        catch (NumberFormatException numberFormatException) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.LONG_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
    }
}

