/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.firebirdsql.jdbc.FBWrappingDataSource;

public class FBDataSourceObjectFactory
implements ObjectFactory {
    private static final Map cfs = new HashMap();

    private String get(Reference ref, String name, String defaultValue) {
        RefAddr ra = ref.get(name);
        if (ra == null) {
            return defaultValue;
        }
        return (String)ra.getContent();
    }

    public synchronized Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        if (cfs.containsKey(name)) {
            return cfs.get(name);
        }
        FBWrappingDataSource ds = new FBWrappingDataSource();
        Reference ref = (Reference)obj;
        String dbName = (String)ref.get("DatabaseName").getContent();
        if (dbName == null) {
            throw new IllegalArgumentException("You must supply a db name");
        }
        ds.setDatabase(dbName);
        ds.setUserName(this.get(ref, "User", null));
        ds.setPassword(this.get(ref, "Password", null));
        ds.setMinSize(Integer.parseInt(this.get(ref, "MinSize", "0")));
        ds.setMaxSize(Integer.parseInt(this.get(ref, "MaxSize", "10")));
        ds.setBlockingTimeout(Integer.parseInt(this.get(ref, "BlockingTimeout", "5000")));
        ds.setIdleTimeoutMinutes(Integer.parseInt(this.get(ref, "IdleTimeoutMinutes", "30")));
        ds.setPooling(true);
        cfs.put(name, ds);
        return ds;
    }
}

