/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.isc_blob_handle;
import org.firebirdsql.gds.isc_db_handle;
import org.firebirdsql.gds.isc_stmt_handle;
import org.firebirdsql.jca.FBLocalTransaction;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBCallableStatement;
import org.firebirdsql.jdbc.FBConnectionHelper;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.jdbc.FBEscapedParser;
import org.firebirdsql.jdbc.FBPreparedStatement;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBSQLParseException;
import org.firebirdsql.jdbc.FBSQLWarning;
import org.firebirdsql.jdbc.FBStatement;

public class FBConnection
implements Connection {
    private boolean autoTransaction = false;
    private boolean invalid = false;
    private FBManagedConnection mc;
    private FBLocalTransaction localTransaction = null;
    private FBDatabaseMetaData metaData = null;
    private SQLWarning firstWarning = null;
    private HashSet activeStatements = new HashSet();

    public FBConnection(FBManagedConnection mc) {
        this.mc = mc;
    }

    protected synchronized void addWarning(SQLWarning warning) {
        if (this.firstWarning == null) {
            this.firstWarning = warning;
        } else {
            SQLWarning lastWarning = this.firstWarning;
            while (lastWarning.getNextWarning() != null) {
                lastWarning = lastWarning.getNextWarning();
            }
            lastWarning.setNextWarning(warning);
        }
    }

    synchronized void checkEndTransaction() throws SQLException {
        if (this.willEndTransaction()) {
            this.autoTransaction = false;
            try {
                this.getLocalTransaction().internalCommit();
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
        }
    }

    private void checkManagedConnection() throws GDSException {
        if (this.mc == null) {
            throw new GDSException(1, 335544363);
        }
    }

    private void checkValidity() throws SQLException {
        if (this.invalid || this.isClosed()) {
            throw new SQLException("This connection is closed and cannot be used now.");
        }
    }

    private void clearIscWarnings() {
        this.mc.clearWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
        this.clearIscWarnings();
    }

    public synchronized void close() throws SQLException {
        try {
            this.freeStatements();
        }
        finally {
            block12: {
                Object var2_1 = null;
                if (this.mc == null) break block12;
                if (!this.getAutoCommit()) {
                    try {
                        try {
                            if (this.inTransaction()) {
                                this.getLocalTransaction().internalRollback();
                            }
                        }
                        catch (GDSException ge) {
                            throw new FBSQLException(ge);
                        }
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        this.setAutoCommit(true);
                        throw throwable;
                    }
                    this.setAutoCommit(true);
                }
                this.mc.close(this);
                this.mc = null;
            }
        }
    }

    public void closeBlob(isc_blob_handle blob) throws GDSException {
        this.checkManagedConnection();
        this.mc.closeBlob(blob);
    }

    public void closeStatement(isc_stmt_handle stmt, boolean deallocate) throws GDSException {
        this.checkManagedConnection();
        this.mc.closeStatement(stmt, deallocate);
    }

    public synchronized void commit() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("You cannot commit a closed connection.");
        }
        if (this.getAutoCommit()) {
            throw new SQLException("commit called with AutoCommit true!");
        }
        try {
            if (this.inTransaction()) {
                this.getLocalTransaction().internalCommit();
            }
        }
        catch (GDSException ge) {
            throw new FBSQLException(ge);
        }
    }

    public synchronized Blob createBlob() throws SQLException {
        if (!this.getAutoCommit()) {
            this.ensureInTransaction();
        }
        return new FBBlob(this);
    }

    public isc_blob_handle createBlobHandle() throws GDSException {
        this.checkManagedConnection();
        return this.mc.createBlobHandle();
    }

    public synchronized Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            this.addWarning(new SQLWarning("Unsupported type and/or concurrency"));
        }
        FBStatement stmt = new FBStatement(this, 1007);
        this.activeStatements.add(stmt);
        return stmt;
    }

    public synchronized Statement createStatement(int param1, int param2, int param3) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public ResultSet doQuery(String sql, List params, HashMap statements) throws SQLException {
        boolean ourTransaction = false;
        FBLocalTransaction trans = null;
        if (!this.inTransaction()) {
            trans = this.getLocalTransaction();
            try {
                trans.internalBegin();
                ourTransaction = true;
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
        }
        PreparedStatement s = this.getStatement(sql, statements);
        int i = 0;
        while (i < params.size()) {
            s.setString(i + 1, (String)params.get(i));
            ++i;
        }
        ResultSet rs = null;
        try {
            s.execute();
            rs = ((FBStatement)((Object)s)).getCachedResultSet(true);
        }
        finally {
            Object var10_10 = null;
            if (ourTransaction) {
                try {
                    trans.internalCommit();
                }
                catch (GDSException ge) {
                    throw new FBSQLException(ge);
                }
            }
        }
        return rs;
    }

    synchronized void ensureInTransaction() throws SQLException {
        try {
            if (this.inTransaction()) {
                this.autoTransaction = false;
                return;
            }
            this.getLocalTransaction().begin();
            this.autoTransaction = true;
        }
        catch (ResourceException re) {
            throw new SQLException("ResourceException: " + re);
        }
    }

    public void executeStatement(isc_stmt_handle stmt, boolean sendOutSqlda) throws GDSException {
        this.checkManagedConnection();
        this.mc.executeStatement(stmt, sendOutSqlda);
    }

    public void fetch(isc_stmt_handle stmt, int fetchSize) throws GDSException {
        this.checkManagedConnection();
        this.mc.fetch(stmt, fetchSize);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private void freeStatements() throws SQLException {
        Set statements = (Set)this.activeStatements.clone();
        Iterator iter = statements.iterator();
        SQLException e = null;
        while (iter.hasNext()) {
            try {
                Statement stmt = (Statement)iter.next();
                stmt.close();
            }
            catch (SQLException ex) {
                if (e != null) {
                    e.setNextException(ex);
                    continue;
                }
                e = ex;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    public isc_stmt_handle getAllocatedStatement() throws GDSException {
        this.checkManagedConnection();
        return this.mc.getAllocatedStatement();
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("You cannot getAutomcommit on an unassociated closed connection.");
        }
        return this.mc.autoCommit;
    }

    public Integer getBlobBufferLength() {
        return this.mc.getBlobBufferLength();
    }

    public byte[] getBlobSegment(isc_blob_handle blob, int len) throws GDSException {
        this.checkManagedConnection();
        return this.mc.getBlobSegment(blob, len);
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    String getDatabase() {
        return this.mc.getDatabase();
    }

    public int getDatabaseProductMajorVersion() {
        return this.mc.getDatabaseProductMajorVersion();
    }

    public int getDatabaseProductMinorVersion() {
        return this.mc.getDatabaseProductMinorVersion();
    }

    public String getDatabaseProductName() {
        return this.mc.getDatabaseProductName();
    }

    public String getDatabaseProductVersion() {
        return this.mc.getDatabaseProductVersion();
    }

    public int getHoldability() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public GDS getInternalAPIHandler() {
        return this.mc.getInternalAPIHandler();
    }

    public isc_db_handle getIscDBHandle() throws GDSException {
        return this.mc.getIscDBHandle();
    }

    String getIscEncoding() {
        return this.mc.getIscEncoding();
    }

    private SQLWarning getIscWarnings() {
        FBSQLWarning firstWarning = null;
        SQLWarning lastWarning = null;
        Iterator iter = this.mc.getWarnings().iterator();
        while (iter.hasNext()) {
            GDSException item = (GDSException)iter.next();
            FBSQLWarning warning = new FBSQLWarning(item);
            if (firstWarning == null) {
                firstWarning = warning;
                lastWarning = firstWarning;
                continue;
            }
            lastWarning.setNextWarning(warning);
            lastWarning = warning;
        }
        return firstWarning;
    }

    public static String getJavaEncoding(String iscEncoding) {
        return FBConnectionHelper.getJavaEncoding(iscEncoding);
    }

    public synchronized FBLocalTransaction getLocalTransaction() {
        if (this.localTransaction == null) {
            this.localTransaction = new FBLocalTransaction(this.mc, this);
        }
        return this.localTransaction;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (this.metaData == null) {
            this.metaData = new FBDatabaseMetaData(this);
        }
        return this.metaData;
    }

    public void getSqlCounts(isc_stmt_handle stmt) throws GDSException {
        this.checkManagedConnection();
        this.mc.getSqlCounts(stmt);
    }

    private PreparedStatement getStatement(String sql, HashMap statements) throws SQLException {
        PreparedStatement s = (PreparedStatement)statements.get(sql);
        if (s == null) {
            s = this.prepareStatement(sql);
            statements.put(sql, s);
        }
        return s;
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            return this.mc.getTransactionIsolation();
        }
        catch (ResourceException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public Map getTypeMap() throws SQLException {
        return new HashMap();
    }

    String getUserName() {
        return this.mc.getUserName();
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning warning = this.firstWarning;
        SQLWarning iscWarning = this.getIscWarnings();
        if (warning == null) {
            warning = iscWarning;
        } else if (iscWarning != null) {
            warning.setNextWarning(iscWarning);
        }
        return warning;
    }

    public boolean inTransaction() {
        return this.mc.inTransaction();
    }

    private void invalidate() {
        this.invalid = true;
    }

    public boolean isClosed() {
        return this.mc == null;
    }

    public boolean isReadOnly() throws SQLException {
        return this.mc.isReadOnly();
    }

    public synchronized String nativeSQL(String sql) throws SQLException {
        try {
            return new FBEscapedParser().parse(sql);
        }
        catch (FBSQLParseException pex) {
            throw new SQLException(pex.toString());
        }
    }

    void notifyStatementClosed(FBStatement stmt) {
        if (!this.activeStatements.remove(stmt)) {
            throw new IllegalArgumentException("Specified statement was not created by this connection.");
        }
    }

    public isc_blob_handle openBlobHandle(long blob_id) throws GDSException {
        this.checkManagedConnection();
        return this.mc.openBlobHandle(blob_id);
    }

    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        FBCallableStatement stmt = new FBCallableStatement(this, sql);
        this.activeStatements.add(stmt);
        return stmt;
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        FBCallableStatement stmt;
        if (resultSetType == 1003 && resultSetConcurrency == 1007) {
            stmt = new FBCallableStatement(this, sql);
        } else {
            this.addWarning(new SQLWarning("resultSetType or resultSetConcurrency changed"));
            stmt = new FBCallableStatement(this, sql);
        }
        this.activeStatements.add(stmt);
        return stmt;
    }

    public synchronized CallableStatement prepareCall(String param1, int param2, int param3, int param4) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void prepareSQL(isc_stmt_handle stmt, String sql, boolean describeBind) throws GDSException {
        this.checkManagedConnection();
        this.mc.prepareSQL(stmt, sql, describeBind);
    }

    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        FBPreparedStatement stmt = new FBPreparedStatement(this, sql);
        this.activeStatements.add(stmt);
        return stmt;
    }

    public synchronized PreparedStatement prepareStatement(String param1, int param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        FBPreparedStatement stmt;
        if (resultSetType == 1003 && resultSetConcurrency == 1007) {
            stmt = new FBPreparedStatement(this, sql);
        } else {
            this.addWarning(new SQLWarning("resultSetType or resultSetConcurrency changed"));
            stmt = new FBPreparedStatement(this, sql);
        }
        this.activeStatements.add(stmt);
        return stmt;
    }

    public synchronized PreparedStatement prepareStatement(String param1, int param2, int param3, int param4) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public synchronized PreparedStatement prepareStatement(String param1, int[] param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public synchronized PreparedStatement prepareStatement(String param1, String[] param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void putBlobSegment(isc_blob_handle blob, byte[] buf) throws GDSException {
        this.checkManagedConnection();
        this.mc.putBlobSegment(blob, buf);
    }

    public void registerStatement(FBStatement fbStatement) {
        this.mc.registerStatement(fbStatement);
    }

    public synchronized void releaseSavepoint(Savepoint param1) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public synchronized void rollback() throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("rollback called with AutoCommit true!");
        }
        if (this.isClosed()) {
            throw new SQLException("You cannot rollback closed connection.");
        }
        try {
            if (this.inTransaction()) {
                this.getLocalTransaction().internalRollback();
            }
        }
        catch (GDSException ge) {
            throw new FBSQLException(ge);
        }
    }

    public synchronized void rollback(Savepoint param1) throws SQLException {
        throw new SQLException("Rollback to savepoint not yet implemented!");
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkValidity();
        if (this.mc.autoCommit != autoCommit) {
            try {
                if (this.inTransaction()) {
                    this.getLocalTransaction().internalCommit();
                }
                this.mc.autoCommit = autoCommit;
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
        }
    }

    public synchronized void setCatalog(String catalog) throws SQLException {
    }

    public void setCursorName(isc_stmt_handle stmt, String cursorName) throws GDSException {
        this.checkManagedConnection();
        this.mc.setCursorName(stmt, cursorName);
    }

    public synchronized void setHoldability(int param1) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setManagedConnection(FBManagedConnection mc) {
        if (this.mc != mc && this.metaData != null) {
            this.metaData.close();
            this.metaData = null;
        }
        this.mc = mc;
    }

    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        this.mc.setReadOnly(readOnly);
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public synchronized Savepoint setSavepoint(String param1) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public synchronized void setTransactionIsolation(int level) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection has being closed.");
        }
        if (this.getTransactionIsolation() != level) {
            try {
                if (this.inTransaction()) {
                    this.getLocalTransaction().internalCommit();
                }
                this.mc.setTransactionIsolation(level);
            }
            catch (ResourceException re) {
                throw new FBSQLException(re);
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
        }
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    synchronized boolean willEndTransaction() throws SQLException {
        return this.getAutoCommit() && this.autoTransaction;
    }
}

